<?php
//custom block category
function custom_block_category( $categories, $post ) {
    return array_merge(
        $categories,
        array(
            array(
                'slug' => 'block-catapulpe',
                'title' => __( 'Blocs Catapulpe', 'block-catapulpe' ),
            ),
        )
    );
}
add_filter( 'block_categories', 'custom_block_category', 10, 2);

// whitelist les blocks selon les type de contenu plutôt que bloqué le post_type des blocks
function wpse_allowed_block_types($allowed_block_types, $post) {

    // Limit blocks in 'page' post type
    if($post->post_type == 'post') {
        // Return an array containing the allowed block types
        return array(
            'acf/bloc-image',
            'acf/bloc-titre-texte',
            'acf/bloc-fichiers',
            'acf/bloc-galerie', //g
            'acf/bloc-video',
        );
    }
    elseif($post->post_type == 'page') {
        return array(
            'acf/bloc-titre-texte',
        );
    }
    elseif($post->post_type == 'ocim') {
        return array(
            'acf/titre-texte-image-citation', //g
            'acf/textes-image', //g
            'acf/equipe', //g
            'acf/bloc-expertises', //g
        );
    }
    elseif($post->post_type == 'observation') {
        return array(
            'acf/contacts',
            'acf/titre-texte-image-citation', //g
            'acf/titre-texte-image-mailchimp', //g
            'acf/textes-image', //g
            'acf/liste-liens', //g
            'acf/chiffres-cles', //g
        );
    }
    elseif($post->post_type == 'ocimotheque') {
        return array(
            'acf/contacts',
            'acf/titre-texte-image-citation', //g
            'acf/textes-image', //g
        );
    }
    elseif($post->post_type == 'accompagnement') {
        return array(
            'acf/contacts',
            'acf/titre-texte-image-citation', //g
            'acf/textes-image', //g
            'acf/grid-blocs-icone', //g
            'acf/liste-image-texte', //g
        );
    }
    elseif($post->post_type == 'carnet') {
        return array(
            'acf/texte-carnet',
            'acf/image-carnet', //g
            'acf/texte-fond-carnet', //g
        );
    }
    // Allow defaults in all other post types
    else {
        return $allowed_block_types;
    }
}
add_filter('allowed_block_types', 'wpse_allowed_block_types', 10, 2);

// Custom blocks
add_action('acf/init', 'my_acf_init_block_types');
function my_acf_init_block_types() {

    $all_post_types        = get_post_types();
    $all_but_articles = array_diff( $all_post_types, array( 'post' ) );

    // Check function exists.
    if( function_exists('acf_register_block_type') ) {
        acf_register_block_type(array(
            'name'              => 'bloc-image',
            'title'             => __('Bloc Image'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',

        ));

        acf_register_block_type(array(
            'name'              => 'bloc-titre-texte',
            'title'             => __('Bloc Titre Texte'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'bloc-fichiers',
            'title'             => __('Bloc Fichiers'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'bloc-galerie',
            'title'             => __('Galerie Photo'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'bloc-son',
            'title'             => __('Bloc Son'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'bloc-video',
            'title'             => __('Bloc Vidéo'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));



        // on garde
        acf_register_block_type(array(
            'name'              => 'contacts',
            'title'             => __('Contacts'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'liste-image-texte',
            'title'             => __('Liste image texte'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));


        // on garde
        acf_register_block_type(array(
            'name'              => 'titre-textes-image',
            'title'             => __('Titre Textes Image'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        acf_register_block_type(array(
            'name'              => 'titre-texte-image-mailchimp',
            'title'             => __('Titre Texte Image Mailchimp'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        acf_register_block_type(array(
            'name'              => 'titre-texte-image-citation',
            'title'             => __('Titre Texte Image Citation'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        acf_register_block_type(array(
            'name'              => 'textes-image',
            'title'             => __('Textes Multiple Image'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'grid-blocs-icone',
            'title'             => __('Grille Blocs Icone'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'liste-liens',
            'title'             => __('Liste Liens'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'chiffres-cles',
            'title'             => __('Chiffres Clés'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'equipe',
            'title'             => __('Équipe'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));


        // project specifics

        // on garde
        acf_register_block_type(array(
            'name'              => 'texte-carnet',
            'title'             => __('Texte - Carnet'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'image-carnet',
            'title'             => __('Image - Carnet'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'texte-fond-carnet',
            'title'             => __('Texte avec fond - Carnet'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));

        // on garde
        acf_register_block_type(array(
            'name'              => 'bloc-expertises',
            'title'             => __('Bloc Expertise'),
            'description'       => __('description'),
            'category'          => 'block-catapulpe',
            'render_template'   => 'acf-blocks/block-template.php',
            'post_types'      => $all_but_articles,
            'example'         => array(
                'attributes' => array(
                    'mode' => 'preview',
                    'data' => 'preview_mode'
                ),
            ),
        ));
    }
}
