<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Custom theme
 * @since 1.0
 */

?>
</div><!-- /site-content -->

<a href="#container" title="Retour en haut de la page" class="scroll-top button scroll-to">
	<div class="bouton-cyan"></div>
	<svg xmlns="http://www.w3.org/2000/svg" width="10" height="7"><path fill-rule="nonzero" d="M5 .5.5 3.695V6.5L5 3.268 9.5 6.5V3.695z"/></svg>
</a>

<footer id="footer">
	<div class="grid-container">
		<div class="grid-x grid-padding-x align-justify">
			<div class="cell large-3">
				<a href="<?= esc_url(home_url('/')); ?>" class="logo">
					<img src="<?= IMG_DIR . '/logo-light.svg'; ?>" alt="<?= get_bloginfo('name'); ?>">
				</a>

				<ul class="small-links">
					<li><a href="https://www.ocim.fr/conditions-generales-de-vente">Conditions générales de vente</a></li>
					<li><a href="https://www.ocim.fr/politique-de-confidentialite">Politique de confidentialité</a></li>
					<li><a href="https://www.ocim.fr/mentions-legales">Mentions légales</a></li>

					<li>
						<div>Création du site web :</div>
						<span onclick="window.open('https://www.tempsreel.fr')">tempsRéel ↗</span>
						<span onclick="window.open('https://www.catapulpe.fr')">Catapulpe ↗</span>
						<span onclick="window.open('https://www.propulse.fr/')">Propulse ↗</span>
					</li>
				</ul>

				<div class="logos">
					<ul>
						<li>
							<img src="<?= IMG_DIR . '/logo-ministere.svg'; ?>" alt="">
						</li>
						<li>
							<img src="<?= IMG_DIR . '/logo-ube.svg'; ?>" alt="">
						</li>
					</ul>
				</div>
			</div>

			<div class="cell large-6 xlarge-4">
				<div class="footer-content-wrapper">
					<div class="footer-content">
						<div class="footer-content-title">L'OCIM vous accueille</div>
						<p>36 rue Chabot-Charny <br> 21000 Dijon</p>
					</div>

					<div class="footer-content">
						<div class="footer-content-title">Contacter l'Ocim</div>
						<p>
							+33 (0)3 80 58 98 50 <br>
							<a href="mailto:ocim@ube.fr"><?= getObfuscatedEmailAddress('ocim@ube.fr');?></a> <br>
							Contact boutique :<br>
							<a href="mailto:boutique.ocim@ube.fr"><?= getObfuscatedEmailAddress('boutique.ocim@ube.fr');?></a> <br>
							<a href="<?= SITEFRONT . '/ocim/lequipe'; ?>">L'équipe de l'Ocim ›</a>
						</p>
					</div>

					<div class="footer-content">
						<div class="footer-content-title">Sur les réseaux</div>
						<div class="socials-wrapper">
							<a class="reseaux-sociaux" href="https://www.facebook.com/p/Office-de-Coop%C3%A9ration-dInformation-Mus%C3%A9ales-Ocim-100064781346797/?locale=fr_FR" target="_blank">
								<svg xmlns="http://www.w3.org/2000/svg" width="7" height="13"><path fill="#FFF" fill-rule="nonzero" d="M6.909.02 4.474 0l-.13.005C3.196.092 1.966 1.327 1.966 2.499v2H0V7.22h1.936V13H4.62V7.19l2.007.001.301-2.67H4.646V3.047c0-.334.25-.6.562-.6l1.7.016V.02Z"/></svg>
							</a>
							<a class="reseaux-sociaux" href="https://twitter.com/ocim_pcsti?lang=fr" target="_blank">
								<svg xmlns="http://www.w3.org/2000/svg" width="12" height="10"><path fill="#FFF" fill-rule="nonzero" d="M.143 0h4.055l2.438 3.126L9.657 0h1.985L7.525 4.264 12 10H7.945L5.281 6.586 1.985 10H0l4.394-4.55L.143 0Zm3.33 1.404h-.415l5.613 7.191h.412l-5.61-7.191Z"/></svg>
							</a>
							<a class="reseaux-sociaux" href="https://www.linkedin.com/company/office-cooperationinformationmuseales/" target="_blank">
								<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="#FFF" fill-rule="nonzero" d="M8.92 3.663c-.967 0-1.682.417-2.116.89V4.05a.194.194 0 0 0-.193-.194H4.304a.194.194 0 0 0-.194.194v7.756c0 .107.087.194.194.194h2.403a.194.194 0 0 0 .194-.194V7.968c0-1.293.35-1.796 1.25-1.796.98 0 1.057.807 1.057 1.863v3.771c0 .107.087.194.194.194h2.404a.194.194 0 0 0 .194-.194V7.552c0-1.923-.366-3.889-3.08-3.889Zm-6.127.193H.384a.194.194 0 0 0-.193.194v7.756c0 .107.086.194.193.194h2.41a.194.194 0 0 0 .193-.194V4.05a.194.194 0 0 0-.194-.194ZM1.59 0a1.592 1.592 0 0 0 0 3.183A1.592 1.592 0 0 0 1.59 0Z"/></svg>
							</a>
						</div>
					</div>

					<div class="footer-content">
						<div class="footer-content-title">La newsletter</div>
						
						<div class="button-wrapper">
							<a href="https://ocim.us19.list-manage.com/subscribe?u=1061769d5e8c2abd831590b60&id=495aaae649" class="button">
								<div class="bouton-cyan"></div>
								<?= __('Je m\'inscris !', 'ocim'); ?>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer>
</div><!-- /container -->

<?php if(!empty(get_field('popup', 'option'))): ?>
	<a href="#event-popup" class="glightbox" style="display: none; position: absolute; left: -1000px; top: -1000px;"></a>
	
	<div id="event-popup" style="display: none;">
		<?= get_field('popup', 'option'); ?>
	</div>
<?php endif; ?>

<?php wp_footer(); ?>

</body>

</html>