<?php

define('THEME_DIR', get_stylesheet_directory_uri());
define('DIST_DIR', THEME_DIR . '/dist');
define('IMG_DIR', THEME_DIR . '/dist/images');
define('IMG_PATH', get_template_directory() . '/dist/images/');
define('SITEFRONT', 'https://www.ocim.fr');


function custom_setup(){
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support('title-tag');

	add_theme_support( 'woocommerce' );
	
	/*
	* This theme styles the visual editor to resemble the theme style,
	* specifically font, colors, and column width.
	*/
	add_theme_support('editor-styles');

	add_editor_style(array(DIST_DIR . '/css/style-editor.css'));
}
add_action('after_setup_theme', 'custom_setup');


function custom_scripts(){
	// Theme stylesheet.
	wp_enqueue_style('custom-style', DIST_DIR . '/css/style.css');

	// include components scripts
	wp_enqueue_script('main', DIST_DIR . '/js/main.js', array('jquery'), '', true);
	wp_localize_script('main', 'adminAjax', array(
		'url' => admin_url('admin-ajax.php'),
		'nonce' => wp_create_nonce('ajax-nonce')
	));
}
add_action('wp_enqueue_scripts', 'custom_scripts');


// Ajoute un fichier de style pour les champs ACF
function admin_custom_scripts() {
	wp_enqueue_style('editor-css', get_stylesheet_directory_uri() . '/dist/css/style-editor.css');
	wp_enqueue_script('admin', get_stylesheet_directory_uri() . '/dist/js/admin.js', array('jquery'), '', true);
}
add_action('admin_enqueue_scripts', 'admin_custom_scripts');


// Désactive les styles de Woocommerce
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );


// Supprime les sidebars de Woocommerce
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);


// Importe toutes les functions contenues dans le dossier /inc
$folderPattern = [
	get_stylesheet_directory() . "/inc/*.php",
	get_stylesheet_directory() . "/inc/woocommerce/*.php",
	get_stylesheet_directory() . "/inc/admin/*.php",
	get_stylesheet_directory() . "/inc/catapulpe/*.php"
];

foreach ($folderPattern as $path) {
	foreach (glob($path) as $filename) {
		include($filename);
	}
}

/**
 * Proper ob_end_flush() for all levels
 *
 * This replaces the WordPress `wp_ob_end_flush_all()` function
 * with a replacement that doesn't cause PHP notices.
 */
remove_action('shutdown', 'wp_ob_end_flush_all', 1);
add_action('shutdown', function () {
	while (@ob_end_flush());
});

// Autoriser tous les rôles à accéder à certaines ressources WooCommerce via l'API REST
add_filter('woocommerce_rest_check_permissions', function($permission, $context, $object_id, $post_type) {
    $user = wp_get_current_user();
    if (!empty($user->roles)) {
        return true; // Autoriser l'accès si l'utilisateur à un rôle (et qu'il a un plan)
    }
    return $permission;
}, 10, 4);