<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 *
 * @package WordPress
 * @subpackage Custom theme
 * @since 1.0
 * @version 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">

<head>
    <meta charset="utf-8">
    <title>Accueil - OCIM</title>
    <meta name="viewport" content="initial-scale=1">
    <link rel="icon" type="image/svg" href="<?= THEME_DIR . '/favicon.svg'; ?>">
    <?php wp_head(); ?>
    <link rel="stylesheet" href="https://use.typekit.net/hbf0vqy.css">

    <script>
		var $ = jQuery;
		document.getElementsByTagName('html')[0].classList.remove('no-js');
	</script>
<!-- Matomo -->
<script>
  var _paq = window._paq = window._paq || [];
  /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
  _paq.push(['trackPageView']);
  _paq.push(['enableLinkTracking']);
  (function() {
    var u="https://utils.ocim.fr/piwik/";
    _paq.push(['setTrackerUrl', u+'matomo.php']);
    _paq.push(['setSiteId', '8']);
    var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
    g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
  })();
</script>
<noscript><p><img referrerpolicy="no-referrer-when-downgrade" src="https://utils.ocim.fr/piwik/matomo.php?idsite=8&amp;rec=1" style="border:0;" alt="" /></p></noscript>
<!-- End Matomo Code -->

</head>

<body <?php body_class(); ?>>
    <div id="container">
        <noscript>
            <div class="no-script">
                <div class="no-script-text"><?= __('Attention javascript est désactivé sur votre poste. <br>Ce site nécessite l\'activation de javascript pour fonctionner correctement.', 'wp_kristall'); ?></div>
            </div>
        </noscript>

        <header class="header visible">
            <div class="grid-container">
                <div class="grid-x grid-padding-x align-center">
                    <div class="cell small-4 medium-3 large-2">
                        <?php if(defined('WP_ENV') && WP_ENV == 'preprod'){
                            $link = site_url('boutique');
                        }else{
                            $link = 'https://www.ocim.fr';
                        }?>
                        <a href="<?= $link; ?>" class="logo">
                            <img src="<?= IMG_DIR . '/Logo_Ocim_Boutique.png'; ?>" alt="<?= get_bloginfo( 'name' ); ?>">
                        </a>
                    </div>

                    <div class="cell small-8 medium-9 large-10 d-flex align-right">
                        <div class="header-top">
                            <button id="toggle-search">
                                <div class="icon-wrapper">
                                    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                        viewBox="0 0 12 12" style="enable-background:new 0 0 12 12;" xml:space="preserve">
                                        <path id="Shape" d="M3,1.5c2-2,5.4-2,7.4,0s2,5.4,0,7.4c-1.8,1.8-4.5,2-6.6,0.7l-2.1,2.1c-0.3,0.3-0.7,0.3-1,0l-0.5-0.5
                                        c-0.3-0.3-0.3-0.7,0-1l2.1-2.1C1,6.1,1.3,3.3,3,1.5z M4.4,7.6c1.3,1.3,3.4,1.3,4.7,0c1.3-1.3,1.3-3.4,0-4.7c-1.3-1.3-3.4-1.3-4.7,0
                                        S3.1,6.3,4.4,7.6z"/>
                                    </svg>
                                </div>
                                <div class="label">Rechercher</div>
                            </button>

                            <?php if ( class_exists( 'WooCommerce' ) ): ?>
                                <?php if(get_page_by_path('panier') && (get_page_by_path('panier')->post_status == 'publish')):
                                    if(defined('WP_ENV') && WP_ENV == 'preprod'){
                                        $cart_link = get_the_permalink(get_page_by_path('panier'));
                                    }else{
                                        $cart_link = 'https://boutique.ocim.fr/panier/';
                                    }

                                    if(!empty($cart_link)): ?>
                                        <a href="<?= $cart_link; ?>" class="basket">
                                            <div class="icon-wrapper">
                                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                    viewBox="0 0 12.4 12.4" style="enable-background:new 0 0 12.4 12.4;" xml:space="preserve">
                                                    <path d="M10.5,2.9h-1C9.3,1.2,7.9,0,6.2,0C4.5,0,3.1,1.2,2.9,2.9h-1C0.9,2.9,0,3.7,0,4.8v4.8c0,1.6,1.3,2.8,2.8,2.8h6.7
                                                    c1.6,0,2.9-1.3,2.9-2.8V4.8C12.4,3.7,11.5,2.9,10.5,2.9z M4.8,2.9c0.2-0.6,0.8-1,1.4-1s1.2,0.4,1.4,1H4.8z M3.1,5.9
                                                    c0.1,0.1,0.3,0.3,0.6,0.3c0.6,0,1-0.4,1-1V4.8h2.9v0.5c0,0.5,0.4,0.9,0.9,0.9c0,0,0,0,0,0c0.2,0,0.5,0,0.7-0.2
                                                    c0.2-0.2,0.3-0.5,0.3-0.7V4.8h0.9l0,4.8c0,0.2-0.1,0.5-0.2,0.6c-0.2,0.2-0.4,0.3-0.7,0.3H2.8c-0.5,0-0.9-0.4-0.9-0.9l0-4.8h1v0.5
                                                    C2.8,5.5,2.9,5.8,3.1,5.9z"/>
                                                </svg>

                                                <div class="nb-items"><?= count( WC()->cart->get_cart() ); ?></div>
                                            </div>

                                            <div class="label">Mon panier</div>
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
        
                                <?php if(get_page_by_path('mon-compte') && (get_page_by_path('mon-compte')->post_status == 'publish')):
                                    if(defined('WP_ENV') && WP_ENV == 'preprod'){
                                        $account_link = get_the_permalink(get_page_by_path('mon-compte'));
                                    }else{
                                        $account_link = 'https://boutique.ocim.fr/mon-compte/';
                                    }

                                    if(!empty($account_link)): ?>
                                        <a href="<?= $account_link; ?>" class="account">
                                            <div class="icon-wrapper">
                                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                    viewBox="0 0 14 18.6" style="enable-background:new 0 0 14 18.6;" xml:space="preserve">
                                                <path d="M14,12.8c0-1.9-1.6-3.5-3.5-3.5h-7C1.6,9.3,0,10.9,0,12.8v3.9c2.1,1.2,4.4,1.9,7,1.9c2.6,0,4.9-0.7,7-2V12.8z M11.7,15.3
                                                    c-1.4,0.6-3,1-4.7,1s-3.2-0.3-4.7-1v-2.5c0-0.6,0.5-1.2,1.2-1.2h7c0.6,0,1.2,0.5,1.2,1.2V15.3z"/>
                                                <path d="M2.3,4.7c0,2.6,2.1,4.7,4.7,4.7s4.7-2.1,4.7-4.7S9.6,0,7,0S2.3,2.1,2.3,4.7z M9.3,4.7C9.3,6,8.3,7,7,7S4.7,6,4.7,4.7
                                                    s1-2.3,2.3-2.3S9.3,3.4,9.3,4.7z"/>
                                                </svg>
                                            </div>

                                            <div class="label">
                                                <?= __('Mon compte', 'ocim'); ?>
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(get_page_by_path('accueil-boutique') && (get_page_by_path('accueil-boutique')->post_status == 'publish')):
                                    if(defined('WP_ENV') && WP_ENV == 'preprod'){
                                        $shop_link = get_the_permalink(get_page_by_path('accueil-boutique'));
                                    }else{
                                        $shop_link = 'https://boutique.ocim.fr/accueil-boutique/';
                                    } ?>
                                    <a href="<?= $shop_link; ?>" class="button">
                                        <div class="bouton-cyan"></div>
                                        <?= __('La boutique', 'ocim'); ?>
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <div class="toggle-wrapper">
                                <div class="navbar-toggle">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </div>
                        </div>

                        <div class="header-content">
                            <?php wp_nav_menu(array(
                                'menu' => 'menu-boutique'
                            )); ?>
                        </div>
                    </div>
                </div>
            </div>
        </header><!-- #masthead -->

        <?= get_search_form(); ?>

        <div id="content" class="site-content">