<?php
function template_wc_user_membership_table_columns( $columns ) {
    $columns = array_slice( $columns, 0, null, true ) + ['column_role' => 'Type de membre'];
    
    return $columns;
}
add_filter( 'manage_edit-wc_user_membership_columns', 'template_wc_user_membership_table_columns', 20, 1 );

function template_wc_user_membership_table_column( $column, $post_id ) {
    switch ( $column){
        case 'column_role':
            $membership = wc_memberships_get_user_membership( $post_id );
            
            if ( $membership ) {
                $user_id = $membership->get_user_id();
                $user = get_user_by('id', $user_id);
                $roles = ( array ) $user->roles;

                if ( ! empty( $roles ) ) {
                    $wp_roles = wp_roles();
                    $role_names = [];
    
                    // Boucler sur les rôles de l'utilisateur et récupérer leur nom d'affichage
                    foreach ( $roles as $role ) {
                        $role_names[] = $wp_roles->roles[ $role ]['name'];
                    }
    
                    // Afficher les rôles (s'il y en a plusieurs, les séparer par des virgules)
                    echo implode( ', ', $role_names );
                }
            }
            break;
    }
}
add_action( 'manage_wc_user_membership_posts_custom_column', 'template_wc_user_membership_table_column', 20, 2 );


// Ajoute des colonnes pour les bons de commande et justificatifs dans l'admin des commandes
add_filter( 'manage_woocommerce_page_wc-orders_columns', 'orders_table_columns', 20, 1 );
function orders_table_columns( $columns ) {
    $columns['column_bdc'] = 'Bon de commande';
    $columns['column_justif'] = 'Justificatif';
    
    return $columns;
}

add_filter('manage_woocommerce_page_wc-orders_custom_column', 'add_order_column_data', 20, 2);
function add_order_column_data($column, $order){
    switch($column){
        case 'column_justif':
            $justificatif = get_post_meta( $order->get_id(), 'ocim_justif', true );
            
            if (! empty( $justificatif ) ) {
                echo 'Oui';
            }
            break;
            
        case 'column_bdc':
            $bon_commande = get_post_meta( $order->get_id(), 'ocim_bdc', true );
            
            if (! empty( $bon_commande ) ) {
                echo 'Oui';
            }
            break;
    }

    return $column;
}