<?php
add_action('admin_enqueue_scripts', 'add_export_button_on_single_order_edit');
function add_export_button_on_single_order_edit($hook)
{
    // Cibler la page de modification d'une commande WooCommerce
    if ($hook === 'woocommerce_page_wc-orders') {
        $order_id = absint($_GET['id']);

        // Construire l'URL vers ta page personnalisée, avec l'ID de la commande
        $url_export = add_query_arg(array(
            'page'=>'export-order-to-sayens',
            'order_id'=> $order_id,
           ), admin_url('admin.php'));
        ?>
        <script type="text/javascript">
            document.addEventListener('DOMContentLoaded', function () {
                const title = document.querySelector('.wp-admin.post-type-shop_order .wrap h1.wp-heading-inline');
                if (title && (title.innerText !== 'Commandes')) {
                    const btn = document.createElement('a');
                    btn.href = '<?= $url_export; ?>';
                    btn.className = 'page-title-action';
                    btn.textContent = 'Générer le xml pour Sayens';

                    // Ajoute le bouton juste après le titre
                    title.insertAdjacentElement('afterend', btn);
                }
            });
        </script>
        <?php
    }
}


add_action('admin_menu', function () {
    add_submenu_page(
        null, // Pas de menu visible
        'Export commande Sayens',
        'Export commande Sayens',
        'manage_woocommerce',
        'export-order-to-sayens',
        'export_to_sayens'
    );
});

function export_to_sayens(){
    $order_id = isset($_GET['order_id']) ? absint($_GET['order_id']) : 0;

    if (!$order_id) {
        wp_die('ID de commande manquant.');
    }

    export_order_to_xml($order_id);

    echo '<div class="wrap">';
    echo '<h2>Le XML Sayens de cette commande a été généré correctement</h2>';

    // Lien vers la commande
    $order_edit_url = admin_url('post.php?post=' . $order_id . '&action=edit');

    echo '<a href="' . esc_url($order_edit_url) . '" class="button button-primary">Retour à la commande</a>';
    echo '</div>';

    exit;
}