<?php
/**
 * Allows Advanced Custom Fields field groups to be displayed on the Memberships
 * plan edit page
 */
add_filter( 'wc_memberships_allowed_meta_box_ids', 'wc_memberships_allow_acf_meta_box_ids' );
function wc_memberships_allow_acf_meta_box_ids( $allowed_meta_box_ids ) {

	if ( function_exists( 'acf_get_field_groups' ) ) {
		$field_groups = array_merge(
			acf_get_field_groups( array( 'post_type' => 'wc_membership_plan' ) ),
			acf_get_field_groups( array( 'post_type' => 'wc_user_membership' ) )
		);

		foreach ( $field_groups as $field_group ) {
			$allowed_meta_box_ids[] = 'acf-' . $field_group['key'];
		}
	}

	return $allowed_meta_box_ids;
}


// Créer automatiquement un plan correspondant au produit qu'on sauvegarde
add_action('woocommerce_process_product_meta', 'create_membership_plan_on_product_save', 10, 3);
function create_membership_plan_on_product_save($post_id) {

    // Vérifie que c'est bien un produit
    if (get_post_type($post_id) !== 'product') {
        return;
    }

    // Ne pas créer de nouveau plan si le produit n'est pas numérique
    if(get_field('format', $post_id) != 'Numérique'){
        return;
    }

    // Récupère le titre du produit
    $membership_plan_title = get_the_title($post_id);

    // Récupère tous les plans d'adhésion
    $existing_plans = wc_memberships_get_membership_plans();

    // Boucle pour vérifier si un plan avec le même titre existe déjà
    $plan_exists = false;
    if (!empty($existing_plans)) {
        foreach ($existing_plans as $plan) {
            if ($plan->get_name() === $membership_plan_title) {
                $plan_exists = true;
                break;
            }
        }
    }

    if ($plan_exists) {
        error_log('Plan already exists for product: ' . $post_id);
        return; // Ne pas créer de nouveau plan s'il en existe déjà un
    }

    // Créer un plan d'adhésion pour le produit
    $plan_data = array(
        'post_title'  => $membership_plan_title, // Utilise le titre du produit pour le nom du plan
        'post_name'   => sanitize_title($membership_plan_title) . '-membership-plan',
        'post_type'   => 'wc_membership_plan',
        'post_status' => 'publish',
    );

    // Insère le plan dans la base de données
    $plan_id = wp_insert_post($plan_data);

    if ($plan_id && !is_wp_error($plan_id)) {
        // Associer le produit au plan pour en faire un produit d'adhésion
        update_post_meta($plan_id, '_product_ids', array($post_id));
    }
}