<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array(  ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION

function admin_css() {
    $admin_handle = 'admin_css';
    $admin_stylesheet = trailingslashit( get_stylesheet_directory_uri() ) . 'admin.css';

    wp_enqueue_style($admin_handle, $admin_stylesheet);
}
add_action('admin_enqueue_scripts', 'admin_css', 11);

// AJout menus
register_nav_menus(
    array(
        'menu-nav' => __( 'Menu Principal', 'catapulpe' ),
        'menu-secondaire' => __( 'Menu Secondaire', 'catapulpe' ),
        'menu-footer' => __( 'Bas de page', 'catapulpe' ),
    )
);

// largeur éditeur gutenberg
function gb_gutenberg_admin_styles() {
    echo '
        <style>
            /* Main column width */
            .wp-block {
                max-width: calc(100% - 20px) !important;
            }
 
            /* Width of "wide" blocks */
            .wp-block[data-align="wide"] {
                max-width: 1080px;
            }
 
            /* Width of "full-wide" blocks */
            .wp-block[data-align="full"] {
                max-width: none;
            }	
        </style>
    ';
}

add_action('admin_head', 'gb_gutenberg_admin_styles');

function add_cors_http_header(){
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Origin: *");
}
add_action('init','add_cors_http_header');


add_filter( 'graphql_jwt_auth_secret_key', function() {
    return 'v=w}n}Hzck|HS+-1k-+7QWN :(wl]t3=x1oEm%g52>`-~bkCc}!_IGL<iI-9Iwxn';
});

//remove comments
function mytheme_admin_bar_render() {
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('comments');
}
add_action( 'wp_before_admin_bar_render', 'mytheme_admin_bar_render' );

add_action( 'admin_menu', 'my_remove_admin_menus' );
function my_remove_admin_menus() {
    remove_menu_page( 'edit-comments.php' );
}

// Blocks ACF
require_once get_theme_file_path('/acf-blocks/blocks-config.php') ;