<?php
function get_main_category($post = null) {
    $main_cat = array();
    $id = !empty($post) ? $post->ID : get_the_id();
    $categories = get_the_category($id);

    // La fonctionnalité de catégorie principale est fournie par Yoast
    if (class_exists('WPSEO_Primary_Term')) :
        $yoast_main_term = new WPSEO_Primary_Term('category', $id);
        $yoast_main_term = $yoast_main_term->get_primary_term();
        $term = get_term($yoast_main_term);

        if (is_wp_error($term)) :
            $main_cat['id'] = $categories[0]->term_id;
            $main_cat['name'] = $categories[0]->name;
            $main_cat['slug'] = $categories[0]->slug;
        else :
            $main_cat['id'] = $term->term_id;
            $main_cat['name'] = $term->name;
            $main_cat['slug'] = $term->slug;
        endif;
    else :
        $main_cat['id'] = $categories[0]->term_id;
        $main_cat['name'] = $categories[0]->name;
        $main_cat['slug'] = $categories[0]->slug;
    endif;

    return $main_cat;
}

function get_main_term($taxonomy, $post = null) {
    $main_cat = array();
    $id = !empty($post) ? $post->ID : get_the_id();
    $categories = get_the_terms($id, $taxonomy);

    // La fonctionnalité de catégorie principale est fournie par Yoast
    if (class_exists('WPSEO_Primary_Term')){
        $yoast_main_term = new WPSEO_Primary_Term($taxonomy, $id);
        $yoast_main_term = $yoast_main_term->get_primary_term();
        $term = get_term($yoast_main_term);

        if (is_wp_error($term)){
            if(!empty($categories)){
                $main_cat['id']   = $categories[0]->term_id;
                $main_cat['name'] = $categories[0]->name;
                $main_cat['slug'] = $categories[0]->slug;
            }
        }else{
            $main_cat['id'] = $term->term_id;
            $main_cat['name'] = $term->name;
            $main_cat['slug'] = $term->slug;
        };
    }else{
        $main_cat['id'] = $categories[0]->term_id;
        $main_cat['name'] = $categories[0]->name;
        $main_cat['slug'] = $categories[0]->slug;
    };

    return $main_cat;
}