<?php

function create_custom_woocommerce_role() {
    global $wp_roles;

    $all_roles = $wp_roles->roles;

    // Vérifie si le rôle "member_role" n'existe pas déjà dans la liste des rôles WordPress
    if(!in_array('member_role', array_keys($all_roles))) {
        // Obtenir les capacités du rôle "customer" de WooCommerce
        $customer_role = get_role('customer');
        
        // Créer un rôle Membre avec les mêmes capacités que le rôle "customer"
        add_role('member_role', 'Membre', $customer_role->capabilities);
        
        // Créer un rôle child_member_role pour les sous-comptes
        add_role('child_member_role', 'Membre enfant', $customer_role->capabilities);
    }    
}
add_action('init', 'create_custom_woocommerce_role');
