<?php
/*
 * Vérifie le contenu d'un tableau, si les clés sont vides, la fonction les supprime
 * 
 * Utilisation : 
 * Vérifie si le tableau est vide : if(!empty(array_remove_empty_keys($array))){}
*/
function clean_empty_array( $array, $make_empty = false ) {
    if ( ! is_array( $array ) ) {
        return;
    }

    foreach ( $array as $key => $value ) {
        if ( is_array( $value ) ) {
            $array[$key] = clean_empty_array( $array[$key] );
        }
        if ( empty( $array[$key] ) ) {
            unset( $array[$key] );
        }
    }

    if ( empty( $array ) && $make_empty ) {
        $array = '';
    }

    return $array;
}


// Recherche une valeur dans un tableau multidimensionnel avec tableaux imbriqués
function find_value_in_array($array, $value) {
    foreach ($array as $key => $element) {
        if (is_array($element)) {
            $result = find_value_in_array($element, $value);
            if ($result) {
                return $result;
            }
        } elseif ($element === $value) {
            return true;
        }
    }
    return false;
}
