<?php
// Récupère tous les plans acheté par le membre "parent", s'il y a un abonnement, on retourne ce produit
// Permet ensuite de créer des sous-comptes avec un abonnement à tarif préférentiel
function has_premium_plan($user_id = null){
    // Récupère l'ID de l'utilisateur actuel si le user n'est pas passé en argument
    if(empty($user_id)) $user_id = get_current_user_id();

    // Récupère les plans de $user
    $user_plans = wc_memberships_get_user_active_memberships($user_id);

    if(!empty($user_plans)){
        foreach($user_plans as $plan){
            $plan_id = $plan->plan_id;
            $now = date("Y-m-d H:i:s");

            $plan = wc_memberships_get_membership_plan($plan_id);

            if(!empty($plan)){
                $end_plan = $plan->get_expiration_date();
            }

            // Si c'est la carte membre de l'année en cours (définie par une checkbox "is_premium_plan" dans le plan) et qu'il n'est pas expiré
            if(!empty(get_field('is_premium_plan', $plan_id)) && ($now < $end_plan)){               
                return wc_memberships_is_user_member($user_id, $plan_id);
            }
        }
    }else{
        return false;
    }
}


function has_active_premium_plan(){
    // Récupérer l'ID de l'utilisateur actuel
    $user_id = get_current_user_id();

    // Récupérer tous les plans
    $active_membership_plans = wc_memberships_get_membership_plans();

    if(!empty($active_membership_plans)){
        foreach($active_membership_plans as $plan){
            $plan_id = $plan->get_id();
            
            // Si c'est la carte membre de l'année en cours (définie par une checkbox "is_premium_plan" dans le plan)
            if(!empty(get_field('is_premium_plan', $plan_id))){
                return wc_memberships_is_user_active_member($user_id, $plan_id);
            }
        }
    }else{
        return false;
    }
}

// Récupère le plan Carte Membre en cours
function get_current_premium_plan() {
    // Vérifie si WooCommerce est chargé
    if ( ! did_action( 'woocommerce_init' ) ) {
        // Si WooCommerce n'est pas encore prêt, on exécute le hook woocommerce_init
        add_action( 'woocommerce_init', 'get_current_premium_plan' );
        return null;
    }

    // Récupère tous les plans
    $membership_plans = wc_memberships_get_membership_plans();

    if(!empty($membership_plans)){
        foreach($membership_plans as $plan){
            $plan_id = $plan->get_id();
            
            // Si c'est la carte membre de l'année en cours (définie par une checkbox "is_premium_plan" dans le plan)
            if(!empty(get_field('is_premium_plan', $plan_id))){
                return $plan;
            }
        }
    }else{
        return false;
    }
}


// Récupère le produit lié au plan Carte Membre
function get_premium_plan_product() {
    // Vérifie si WooCommerce est chargé
    if ( ! did_action( 'woocommerce_init' ) ) {
        // Si WooCommerce n'est pas encore prêt, on exécute le hook woocommerce_init
        add_action( 'woocommerce_init', 'get_premium_plan_product' );
        return null;
    }

    $current_premium_plan = get_current_premium_plan();
    $plan_product_ids = '';

    if(!empty($current_premium_plan)){
        // Récupère les produits liés
        $plan_product_ids = $current_premium_plan->get_product_ids();
    }else{
        return false;
    }

    if(!empty($plan_product_ids)){
        return wc_get_product($plan_product_ids[0]);
    }else{
        return false;
    }
}


// Retourne l'id de la variation par défaut d'un produit variable
function get_default_variation_id($product){
    if (!empty($product) && $product->is_type('variable')) {
        // Récupérer la variation par défaut
        $default_attributes = $product->get_default_attributes();
        $variations = $product->get_available_variations();

        foreach ($variations as $variation) {
            if (isset($variation['attributes']) && is_array($variation['attributes'])) {
                $match = true; // On part du principe qu'il y a une correspondance

                foreach ($default_attributes as $key => $value) {
                    if (isset($variation['attributes'][$key]) && $variation['attributes'][$key] !== $value) {
                        $match = false; // Pas une correspondance
                        break;
                    }
                }

                if ($match) {
                    return $variation['variation_id']; // Retourner l'ID de la variation par défaut
                }
            }
        }
    }
    return null; // Retourne null si ce n'est pas un produit variable ou s'il n'y a pas de variation par défaut
}


// Retourne l'id de la variation correspondant à l'attribut et la valeur passées en paramètre
function get_variation_by_attribute_value($product, $attribute, $attribute_value){
    if (!empty($product) && $product->is_type('variable')) {
        // Récupérer la variation par défaut
        $variations = $product->get_available_variations();

        foreach ($variations as $variation) {
            if (isset($variation['attributes']) && is_array($variation['attributes'])) {
                foreach ($variation['attributes'] as $key => $value) {
                    if (($key == $attribute) && ($value == $attribute_value)) {
                        return $variation['variation_id'];
                    }
                }
            }
        }
    }
    return null; // Retourne null si ce n'est pas un produit variable ou s'il n'y a pas de variation par défaut
}


// Récupère le taux de TVA Standard (20%)
function get_default_tax_rate(){
    $default_tax_class = 'standard';
    $tax_rates = WC_Tax::get_rates_for_tax_class( $default_tax_class );

    $fr_tax_rates = array_filter($tax_rates, function($rate) {
        return isset($rate->tax_rate_country) && $rate->tax_rate_country === 'FR';
    });

    $fr_tax_rate = !empty($fr_tax_rates) ? reset($fr_tax_rates) : null;

    $tax_rate = array();
    $tax_rate['rate'] = floatval($fr_tax_rate->tax_rate);

    if ( ! empty( $tax_rates ) ) {
        return $tax_rate;
    }

    return false;
}


// Récupère le taux de TVA en fonction du produit passé en paramètre
function get_tax_rate_by_product( $product ) {
    if(empty($product)) return;

    if(!empty($product->get_tax_class())){
        $tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
    }
    
    $tax_rate = isset($tax_rates) ? reset( $tax_rates ) : get_default_tax_rate();
    
    return floatval( $tax_rate['rate'] );
}

// Récupère le taux de TVA en fonction de son nom
function get_tax_rate_by_name( $tax_name ) {
    $tax_rates = WC_Tax::get_rates( $tax_name );
    $tax_rate = reset( $tax_rates );
    return isset( $tax_rate['rate'] ) ? floatval( $tax_rate['rate'] ) : 0;
}


// Récupère le taux de TVA pour la variation du produit
function get_variation_tax_rate( $variation ) {
    // Vérifie si l'objet est bien une variation
    if ( $variation && $variation->is_type('variation') ) {
        // Récupère le nom de taxe de la variation
        $tax_name = $variation->get_tax_class();

        // Si aucune classe n'est définie, WooCommerce applique la classe 'standard'
        $parent_product = '';

        // Si le nom de taxe de la variation est vide, ca veut dire que c'est la même que celle du produit parent
        if ( empty( $tax_name ) ) {
            $parent_product = wc_get_product($variation->get_parent_id());
            
            // On récupère le nom de la taxe du produit parent
            $tax_name = $parent_product ? $parent_product->get_tax_class() : '';
        }
        
        // Si $tax_name est vide ca veut dire que c'est la taxe Standard, on récupère le taux de la taxe Standard
        $variation_tax_rate = !empty(get_tax_rate_by_name($tax_name)) ? get_tax_rate_by_name($tax_name) : get_default_tax_rate()['rate'];

        if(!empty($variation_tax_rate)){
            return $variation_tax_rate;
        }
    }
    return array(); // Retourne un tableau vide si l'objet n'est pas une variation valide
}


// Récupère le nombre de sous-compte disponible pour le compte $user_id
function get_empty_child_account($user_id = null){
    // Récupère l'ID de l'utilisateur actuel si le user n'est pas passé en argument
    if(empty($user_id)) $user_id = get_current_user_id();
    
    return get_user_meta($user_id, 'empty_child_account', true);
}

// Met à jour la meta empty_child_account du compte $user_id
function set_empty_child_account($value, $user_id = null){
    // Récupère l'ID de l'utilisateur actuel si le user n'est pas passé en argument
    if(empty($user_id)) $user_id = get_current_user_id();
    
    update_user_meta($user_id, 'empty_child_account', $value);
}


// Affiche le nombre de sous-compte encore disponible pour la carte membre en cours
function display_empty_child_account_in_my_account() {
    $empty_child_account = get_empty_child_account();
    $message = '';

    if (!empty($empty_child_account)) {
        get_premium_plan_product();

        if($empty_child_account > 1){
            $subaccount_text = 'sous-comptes disponibles';
        }else{
            $subaccount_text = 'sous-compte disponible';
        }
        $message = '<strong>Il vous reste :</strong> ' . esc_html($empty_child_account) . ' ' . $subaccount_text . ' pour ' . get_premium_plan_product()->get_name();
    }

    if(!empty($message)){
        echo '<p class="account-remaining">' . $message . '</p>';
    }
}


// Vérifie si le post passé en paramètre est un contenu restreint
function is_a_restricted_content($post_id){
	/* if (   ! current_user_can( 'wc_memberships_view_delayed_post_content',    $post_id )
	|| ! current_user_can( 'wc_memberships_view_restricted_post_content', $post_id ) ) {
        return true;
	} */
    if ( wc_memberships_is_post_content_restricted( get_the_id() ) ) {
        return true;
        /* if ( wc_memberships_user_can( get_current_user_id(), 'view', [ 'post' => get_the_id() ] ) ) {
          // the user is a member who can view this content
        } else {
          // the user cannot view this content right now
        } */
      }

	return false;
}


// Vérifie si on met les prix ht ou ttc
function tva_to_zero($billing_country = null){
    // Récupère le pays de facturation du client
    if( $billing_country == null){
        $billing_country = WC()->customer->get_billing_country();
    }

    // Condition pour appliquer ou non la TVA
    $tva_to_zero = true;
    switch($billing_country){
        case 'FR':
        case 'MC':
            $tva_to_zero = false;
            break;
        default:
            $tva_to_zero = true;
            break;
    }

    return $tva_to_zero;
}


function is_country_in_eu($country) {
    // Obtenir la liste des pays de l'UE
    $eu_countries = WC()->countries->get_european_union_countries();

    // Vérifier si le pays de facturation est dans la liste
    return in_array( $country, $eu_countries, true );
}