<?php
// Dans l'admin, dans les commandes, affiche les données des sous-comptes créés
add_action( 'woocommerce_after_order_itemmeta', 'display_subaccount_data_in_admin', 10, 3 );
function display_subaccount_data_in_admin( $item_id, $item, $product ) {
    // Récupérer les données des sous-comptes
    $subaccount_data = wc_get_order_item_meta( $item_id, 'subaccount_data', true );

    // Si les données existent, les afficher
    if (!empty($subaccount_data)) {

        echo '<p><strong>Sous-compte :</strong></p>';
        echo '<ul>';
        foreach ($subaccount_data as $key => $value) {
            if(!empty($key) && !empty($value)) {
                switch($key){
                    case 'email':
                        $label = 'Email';
                        break;
                    case 'first_name':
                        $label = 'Prénom';
                        break;
                    case 'last_name':
                        $label = 'Nom';
                        break;
                    case 'company':
                        $label = 'Entreprise';
                        break;
                    case 'address_1':
                        $label = 'Adresse';
                        break;
                    case 'address_2':
                        $label = 'Complément d\'adresse';
                        break;
                    case 'city':
                        $label = 'Ville';
                        break;
                    case 'postcode':
                        $label = 'Code postal';
                        break;
                    case 'phone':
                        $label = 'Téléphone';
                        break;
                    case 'country':
                        $label = 'Pays';                        
                        break;
                }

                echo '<li>' . $label . ' : ' . esc_html($value) . '</li>';
            }
        }
        echo '</ul>';
    }
}


// Affiche les id user memberships du compte (dans l'admin)
add_action('show_user_profile', 'custom_user_profile_fields');
add_action('edit_user_profile', 'custom_user_profile_fields');
function custom_user_profile_fields( $user ) {
    $user_meta = get_user_meta( $user->ID, 'ocim_user_memberships', true );

    echo '<h3>Adhésions Membership</h3>';
    echo '<table class="form-table">';
    echo '<tr>';
    echo '<th><label for="ocim_user_memberships">ID des Adhésions</label></th>';
    echo '<td>';
    if (!empty($user_meta) && is_array($user_meta)) {
        echo '<ul>';
        foreach ($user_meta as $membership_id) {
            echo '<li>' . esc_html($membership_id) . '</li>';
        }
        echo '</ul>';
    } else {
        echo '<p>Aucune adhésion associée.</p>';
    }
    echo '</td>';
    echo '</tr>';
    echo '</table>';
}


// Lors de la sauvegarde d'un plan, on récupère les id des contenus autorisés par celui-ci les ajoute en meta_data du plan
add_action('save_post', 'add_accessible_content_ids_to_membership_plan_meta', 10, 3);
function add_accessible_content_ids_to_membership_plan_meta($post_id, $post, $update) {
    // Vérifier si le type de post est un plan de membres
    if ($post->post_type == 'wc_membership_plan') {
        
        // Récupérer le plan Membership
        $plan = wc_memberships_get_membership_plan($post_id);
        if (!$plan) {
            return;
        }

        $content_ids = get_plan_accessible_content_ids($plan->get_id());
        $content_ids_json = wp_json_encode($content_ids);
    
        // Mettre à jour la métadonnée avec les IDs des contenus
        update_post_meta($post_id, 'ocim_accessible_content_ids', $content_ids_json);
    }
}


function get_plan_accessible_content_ids( $plan_id ) {
    $plan = wc_memberships_get_membership_plan( $plan_id );

    if ( ! $plan ) {
        return [];
    }

    // Utilisation de la méthode privée via reflection pour accéder à `get_restricted`
    $reflection = new ReflectionClass( $plan );
    $method = $reflection->getMethod('get_restricted');
    $method->setAccessible(true);

    // Récupérer les contenus restreints du plan
    $query = $method->invoke( $plan, 'content_restriction' );
    
    // Modifie la requête pour inclure posts_per_page
    if ( $query instanceof WP_Query ) {
        $query->set( 'posts_per_page', 99999 ); // 9999 pour tous les posts (ou presque)
        $query->get_posts(); // Exécuter à nouveau la requête avec le nouveau paramètre
    }

    if ( ! $query || ! $query->have_posts() ) {
        return [];
    }

    // Récupérer les IDs des contenus
    return wp_list_pluck( $query->posts, 'ID' );
}