<?php
// Supprime les ventes croisées du hook woocommerce_cart_collaterals
add_action('wp', function() {
    remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
});


// Ajoute les coordonnées des sous-comptes dans les produits du panier
add_action('woocommerce_add_cart_item_data', 'handle_add_multiple_subaccounts_to_cart', 10, 3);
function handle_add_multiple_subaccounts_to_cart($cart_item_data, $product_id, $variation_id){

    // Si on vient du compte pour créer des sous-comptes
    if (isset($_POST['add_product_to_cart']) && is_user_logged_in()) {
        // Récupérer les données de sous-compte pour le produit
        $index = isset($_POST['index']) ? intval($_POST['index']) : 0;
        $keys = array('email', 'first_name', 'last_name', 'company', 'country', 'address_1', 'address_2', 'postcode', 'city', /*'phone', 'state',*/);
        $array_data = array();

        // Récupère dans un tableau pour chaque $keys les valeurs correspondantes
        foreach ($keys as $key) {
            $matching_values = array_filter($_POST, function($data_key) use ($key) {
                return strpos($data_key, $key) !== false;
            }, ARRAY_FILTER_USE_KEY);
            
            // Ajoute les valeurs au tableau des résultats sous la clé actuelle
            $array_data[$key] = array_values($matching_values);
        }
        
        // Sanitize and prepare the arrays
        $emails      = isset($array_data['email']) ? array_map('sanitize_email', $array_data['email']) : [];
        $first_names = isset($array_data['first_name']) ? array_map('sanitize_text_field', $array_data['first_name']) : [];
        $last_names  = isset($array_data['last_name']) ? array_map('sanitize_text_field', $array_data['last_name']) : [];
        $companies   = isset($array_data['company']) ? array_map('sanitize_text_field', $array_data['company']) : [];
        $countries   = isset($array_data['country']) ? array_map('sanitize_text_field', $array_data['country']) : [];
        $address_1   = isset($array_data['address_1']) ? array_map('sanitize_text_field', $array_data['address_1']) : [];
        $address_2   = isset($array_data['address_2']) ? array_map('sanitize_text_field', $array_data['address_2']) : [];
        $postcodes   = isset($array_data['postcode']) ? array_map('sanitize_text_field', $array_data['postcode']) : [];
        $cities      = isset($array_data['city']) ? array_map('sanitize_text_field', $array_data['city']) : [];
        //$states      = isset($array_data['state']) ? array_map('sanitize_text_field', $array_data['state']) : [];

        // Vérifier si un sous-compte utilise une adresse e-mail existante
        foreach ($emails as $email) {
            if (email_exists($email)) {
                wc_add_notice('L\'adresse email ' . esc_html($email) . ' est déjà utilisée.', 'error');
                return $cart_item_data;
            }
        }

        // Ajouter chaque sous-compte comme un item distinct
        $empty_child_account = get_empty_child_account();
        $temp_empty_child_account = $empty_child_account;
        foreach ($emails as $index => $email) {
            $cart_item_data['subaccount_data'][$index] = array(
                'email'      => $email,
                'first_name' => $first_names[$index],
                'last_name'  => $last_names[$index],
                'company'    => $companies[$index],
                'country'    => $countries[$index],
                'address_1'  => $address_1[$index],
                'address_2'  => $address_2[$index],
                'postcode'   => $postcodes[$index],
                'city'       => $cities[$index],
                //'state'      => $states[$index],
            );
            
            /* S'il reste des sous-comptes disponibles, on ajoute la meta empty_child_account à true
             * Pour que le produit dans le panier soit à 0€
             */
            if(!empty($temp_empty_child_account)){
                $cart_item_data['subaccount_data'][$index]['empty_child_account'] = true;
            }
            
            $temp_empty_child_account--;
        }


        // Empêcher la fusion des articles du panier
        $cart_item_data['unique_key'] = md5(microtime() . rand());

        return $cart_item_data;
    }
    
    return $cart_item_data;
}


// Affiche les informations des sous-comptes dans les items du panier dans la page Cart et Checkout
add_filter('woocommerce_get_item_data', 'display_subaccount_data_in_cart', 10, 2);
function display_subaccount_data_in_cart($item_data, $cart_item) {
    
    if (isset($cart_item['subaccount_data'])) {
        $subaccount_data = $cart_item['subaccount_data'];

        if(isset($subaccount_data['email']) && !empty($subaccount_data['email'])){
            $item_data[] = array(
                'name' => 'Email',
                'value' => $subaccount_data['email']
            );
        }
        if(isset($subaccount_data['first_name']) && !empty($subaccount_data['first_name'])){
            $item_data[] = array(
                'name' => 'Prénom',
                'value' => $subaccount_data['first_name']
            );
        }
        if(isset($subaccount_data['last_name']) && !empty($subaccount_data['last_name'])){
            $item_data[] = array(
                'name' => 'Nom',
                'value' => $subaccount_data['last_name']
            );
        }
        if(isset($subaccount_data['company']) && !empty($subaccount_data['company'])){
            $item_data[] = array(
                'name' => 'Entreprise',
                'value' => $subaccount_data['company']
            );
        }
        if(isset($subaccount_data['address_1']) && !empty($subaccount_data['address_1'])){
            $item_data[] = array(
                'name' => 'Addresse',
                'value' => $subaccount_data['address_1']
            );
        };
        if(isset($subaccount_data['address_2']) && !empty($subaccount_data['address_2'])){
            $item_data[] = array(
                'name' => 'Complément d\'addresse',
                'value' => $subaccount_data['address_2']
            );
        };
        if(isset($subaccount_data['city']) && !empty($subaccount_data['city'])){
            $item_data[] = array(
                'name' => 'Ville',
                'value' => $subaccount_data['city']
            );
        };
        if(isset($subaccount_data['postcode']) && !empty($subaccount_data['postcode'])){
            $item_data[] = array(
                'name' => 'Code postal',
                'value' => $subaccount_data['postcode']
            );
        };
        /* if(isset($subaccount_data['state']) && !empty($subaccount_data['state'])){
            $item_data[] = array(
                'name' => 'State',
                'value' => $subaccount_data['state']
            );
        }; */
        if(isset($subaccount_data['country']) && !empty($subaccount_data['country'])){
            $countries = WC()->countries->get_countries();
            $value = $subaccount_data['country'];
            
            $country_name = isset($countries[$value]) ? $countries[$value] : $value;
            
            $item_data[] = array(
                'name' => 'Pays',
                'value' => $country_name
            );
        };
        if(isset($subaccount_data['phone']) && !empty($subaccount_data['phone'])){
            $item_data[] = array(
                'name' => 'Téléphone',
                'value' => $subaccount_data['phone']
            );
        };
    }

    // S'il y a un formulaire pour la biennale dans un item du panier, on affiche ses valeurs dans l'item
    if (isset($cart_item['biennale_data'])) {
        $biennale_data = $cart_item['biennale_data'];
        
        if ( isset( $biennale_data['name'] ) ) {
            $item_data[] = array(
                'name'  => __( 'Nom', 'ocim' ),
                'value' => sanitize_text_field( $biennale_data['name'] ),
            );
        }

        if ( isset( $biennale_data['first_name'] ) ) {
            $item_data[] = array(
                'name'  => __( 'Prénom', 'ocim' ),
                'value' => sanitize_text_field( $biennale_data['first_name'] ),
            );
        }
        if ( isset( $biennale_data['job'] ) ) {
            $item_data[] = array(
                'name'  => __( 'Fonction', 'ocim' ),
                'value' => sanitize_text_field( $biennale_data['job'] ),
            );
        }
        if ( isset( $biennale_data['email'] ) ) {
            $item_data[] = array(
                'name'  => __( 'Email', 'ocim' ),
                'value' => sanitize_email( $biennale_data['email'] ),
            );
        }
    }

    return $item_data;
}


add_action('woocommerce_before_calculate_totals', 'update_cart_subaccount_data');
function update_cart_subaccount_data($cart) {
    
    // S'assurer que le panier n'est pas vide
    if (is_admin() || !did_action('woocommerce_before_calculate_totals') || WC()->cart->is_empty()) {
        return;
    }

    // On récupère le produit lié au plan Carte membre
    $premium_product = get_premium_plan_product();

    if ( empty( $premium_product ) ) {
        return;
    }

    $premium_product_id = $premium_product->get_id();

    $empty_child_length = intval(get_empty_child_account());

    foreach ($cart->cart_contents as $cart_item_key => $cart_item) {
        // Si le produit dans le panier et le même que la carte membre, on peut ajouter empty_child_account aux data de l'item panier
        if($cart_item['product_id'] == $premium_product_id){
            if(!empty($empty_child_length) && $empty_child_length > 0){
                $cart_item['subaccount_data']['empty_child_account'] = true;
            }else{
                unset($cart_item['subaccount_data']['empty_child_account']);
            }
            
            $cart->cart_contents[$cart_item_key] = $cart_item;
            $empty_child_length--;
        }
    }
    
    // Sauvegarder les modifications dans la session
    $cart->set_session();
};


/**
 * Prix item panier : 
 * Depuis le compte Membre parent, si on a un sous-compte disponible et qu'on ajoute un sous-compte, dans le panier le prix doit être de 0
 * Afficher le prix à 0 dans la liste des produits du panier
 */
add_filter('woocommerce_cart_item_price', 'display_zero_price_in_cart', 10, 3);
function display_zero_price_in_cart($price, $cart_item, $cart_item_key) {
    if (is_user_logged_in() && has_premium_plan()) {
        // S'il y a la data empty_child_account, on met le prix à 0
        if(isset($cart_item['subaccount_data'])){
            if(isset($cart_item['subaccount_data']['empty_child_account'])){
                $price = wc_price(0); // Définit le prix à 0
            }
        }
    }

    return $price;
}


// Lors de la mise à jour du panier, affiche les données des champs remplis
add_action('woocommerce_update_cart_action_cart_updated', 'save_custom_shipping_fields_to_cart');
function save_custom_shipping_fields_to_cart() {
    // Parcourir chaque item du panier pour traiter les données
    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
        if (isset($_POST['subaccount_data'][$cart_item_key]) && !empty(clean_empty_array($_POST['subaccount_data'][$cart_item_key]))) {

            $cart_item_data = $_POST['subaccount_data'][$cart_item_key];
            
            // Vérifie et nettoye les valeurs des champs
            $email      = isset($cart_item_data['email']) && !empty($cart_item_data['email']) ? sanitize_email($cart_item_data['email']) : '';
            $first_name = isset($cart_item_data['shipping_first_name']) && !empty($cart_item_data['shipping_first_name']) ? sanitize_text_field( $cart_item_data['shipping_first_name']) : '';
            $last_name  = isset($cart_item_data['shipping_last_name']) && !empty($cart_item_data['shipping_last_name']) ? sanitize_text_field( $cart_item_data['shipping_last_name']) : '';
            $company    = isset($cart_item_data['shipping_company']) && !empty($cart_item_data['shipping_company']) ? sanitize_text_field( $cart_item_data['shipping_company']) : '';
            $country    = isset($cart_item_data['shipping_country']) && !empty($cart_item_data['shipping_country']) ? sanitize_text_field( $cart_item_data['shipping_country']) : '';
            $address_1  = isset($cart_item_data['shipping_address_1']) && !empty($cart_item_data['shipping_address_1']) ? sanitize_text_field( $cart_item_data['shipping_address_1']) : '';
            $address_2  = isset($cart_item_data['shipping_address_2']) && !empty($cart_item_data['shipping_address_2']) ? sanitize_text_field( $cart_item_data['shipping_address_2']) : '';
            $city       = isset($cart_item_data['shipping_city']) && !empty($cart_item_data['shipping_city']) ? sanitize_text_field( $cart_item_data['shipping_city']) : '';

            if(isset($cart_item_data['shipping_postcode']) && !empty($cart_item_data['shipping_postcode'])){
                $postcode = preg_replace( '/[^0-9]/', '', $cart_item_data['shipping_postcode']);
                $postcode = !empty($postcode) ? sanitize_text_field($postcode) : '';
            }

            //$states      = isset($array_data['state']) ? array_map('sanitize_text_field', $array_data['state']) : [];


            // Validation des champs requis
            $errors = [];
            
            if (email_exists($email)) {
                $errors[] = 'Un compte avec cette adresse mail existe déjà';
            }
            if (empty($email) || !is_email($email)) {
                $errors[] = 'L\'adresse e-mail est requise et doit être valide.';
            }
            if (empty($first_name)) {
                $errors[] = 'Le prénom est requis.';
            }
            if (empty($last_name)) {
                $errors[] = 'Le nom de famille est requis.';
            }
            if (empty($address_1)) {
                $errors[] = 'L\'adresse est requise.';
            }
            if (empty($city)) {
                $errors[] = 'La ville est requise.';
            }
            if (empty($country)) {
                $errors[] = 'Le pays est requis.';
            }
            if (empty($postcode)) {
                $errors[] = 'Le code postal est requis.';
            }

            // Si des erreurs sont détectées, ajoutez-les en tant que messages d'erreur et ne redirigez pas
            if (!empty($errors)) {
                foreach ($errors as $error) {
                    wc_add_notice($error, 'error');
                }
                return; // Empêche la redirection vers le panier
            }

            $item_account_data = array(
                'email'      => $email,
                'first_name' => $first_name,
                'last_name'  => $last_name,
                'company'    => $company,
                'country'    => $country,
                'address_1'  => $address_1,
                'address_2'  => $address_2,
                'postcode'   => $postcode,
                'city'       => $city,
                //'state'      => $states[$index],
            );

            // Ajoute à l'item de panier les données des champs
            WC()->cart->cart_contents[$cart_item_key]['subaccount_data'] = $item_account_data;
        }
    }

    // Enregistre le panier mis à jour
    WC()->cart->set_session();
}


/**
 * Sous-total d'un item panier :
 * Affiche le prix HT et TTC du sous-total de chaque produit dans le panier
 */
add_filter( 'woocommerce_cart_item_subtotal', 'display_price_ht_and_ttc_in_cart_total', 10, 3 );
function display_price_ht_and_ttc_in_cart_total( $subtotal, $cart_item, $cart_item_key ) {
    // Depuis le compte Membre parent, si on a un sous-compte disponible et qu'on ajoute un sous-compte, dans le panier le prix doit être de 0
    $new_subtotal = false;

    if (is_user_logged_in() && has_premium_plan()) {
        // S'il y a la data empty_child_account, on met le prix à 0
        if(isset($cart_item['subaccount_data'])){
            if(isset($cart_item['subaccount_data']['empty_child_account'])){
                $subtotal = wc_price(0); // Définit le prix à 0
                $new_subtotal = true;
            }
        }
    }

    $product = $cart_item['data'];
    if ( $product->is_taxable() ) {
        // Récupération du prix brut (TTC)
        $price_ttc = wc_get_price_to_display( $product );

        // Récupération du taux de TVA
        $tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
        if(!empty( $tax_rates )){
            $tax_rates = reset ( $tax_rates );
        }

        if(isset( $tax_rates['rate'] )){
            $tax_rate = $tax_rates['rate'];
        }

        $tax_percentage = isset( $tax_rate ) ? $tax_rate : 0;
        $tax_label = !empty($tax_rates['label']) ? $tax_rates['label'] : 'TTC';
        
        // Calcul du prix HT
        $price_ht = $price_ttc / ( 1 + ($tax_percentage/100) );

        // Formatte les prix HT et TTC
        $price_ht_formatted = wc_price( $price_ht );
        $price_ttc_formatted = wc_price( $price_ttc );

        // Si TVA à zéro
        if(tva_to_zero()){
            $subtotal = '<div class="price-ttc">' . $price_ttc_formatted . '</div>';
        }else{
            // Affiche les prix HT et TTC dans le subtotal
            $subtotal = '<div class="price-ht">' . $price_ht_formatted . ' <small>HT</small></div>';
            $subtotal .= '<div class="price-ttc">' . $price_ttc_formatted . ' <small>' . $tax_label . '</small></div>';
        }

    }


    return $subtotal;
}


// Définir le prix réel de l'article à 0 dans le total du panier
add_action('woocommerce_before_calculate_totals', 'force_zero_price_for_specific_product', 10, 1);
function force_zero_price_for_specific_product($cart) {
    foreach ($cart->get_cart() as $cart_item) {
        if (is_user_logged_in() && has_premium_plan()) {
            // S'il y a la data empty_child_account, on met le prix à 0
            if(isset($cart_item['subaccount_data'])){
                if(isset($cart_item['subaccount_data']['empty_child_account'])){
                    $cart_item['data']->set_price(0); // Définit le prix à 0
                }
            }
        }
    }
}


// Dans le panier, s'il y a une Carte membre avec quantité > 1, on ajoute autant de produits Sous-compte que de quantité - 1 au panier et ramène à 1 la quantité de Carte membre
// On met un produit sous-compte par ligne dans le tableau
add_action('woocommerce_after_calculate_totals', 'custom_cart_variation_swap', 10, 1);
function custom_cart_variation_swap($cart) {
    // Marqueur global pour empêcher l'exécution multiple
    if (did_action('custom_cart_variation_swap_executed') > 0) return;
    do_action('custom_cart_variation_swap_executed');

    // Récupère le produit Carte membre de l'année en cours
    $premium_product = get_premium_plan_product();

    if ( empty( $premium_product ) ) {
        return;
    }

    if(!empty($premium_product)){
        $premium_product_id = $premium_product->get_id();
        
        // Récupère l'id de la variation plein tarif
        $normal_variation_id = get_default_variation_id($premium_product);
        
        // Récupère l'id de la variation sous-compte de l'attribut tarif préférentiel
        $discounted_variation_id = get_variation_by_attribute_value($premium_product, 'attribute_pa_tarif-preferentiel', 'sous-compte');
    }

    // Vérifie que l'action n'est pas en cours dans l'admin ou via une requête AJAX
    if (is_admin() && !defined('DOING_AJAX')) return;

    
    // Parcourt les articles dans le panier
    foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
        // Vérifie si l'article dans le panier correspond au produit Carte membre et à la variation tarif normal
        if ($cart_item['product_id'] == $premium_product_id && $cart_item['variation_id'] == $normal_variation_id) {
            $quantity = $cart_item['quantity'];

            // Si la quantité est de 2 ou plus, modifie l'article
            if ($quantity > 1) {
                // Ajuste la quantité de la variation normale à 1
                $cart->set_quantity($cart_item_key, 1);

                // Ajoute un article avec la variation "Sous-compte" pour les unités restantes
                $remaining_quantity = $quantity - 1;

                // Cherche si la variation "Sous-compte" est déjà dans le panier
                for ($i = 0; $i < $remaining_quantity; $i++) {
                    // Ajoute un nouvel article avec la variation "Sous-compte" pour chaque unité restante
                    $unique_key = md5(microtime() . rand());
                    $cart->add_to_cart($premium_product_id, 1, $discounted_variation_id, array(), array('unique_key' => $unique_key));
                }
            }
        }
    }
}


//add_action( 'woocommerce_cart_subtotal','woocommerce_custom_surcharge', 10, 1 );
function woocommerce_custom_surcharge( $cart_subtotal ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;

    
    // Calculer le sous-total hors taxe
    $subtotal_excl_tax = WC()->cart->get_subtotal();


    // Si TVA à zéro
    if ( tva_to_zero() ) {
        // Affiche uniquement le sous-total HT
        $cart_subtotal = wc_price( $subtotal_excl_tax ) . ' <small>HT</small>';
    }

    return $cart_subtotal;
}


// S'il y a une variation de la Carte membre autre que plein-tarif on n'affiche pas le input de quantité, affiche seulement la quantié en texte
// En effet, il n'est pas possible d'ajouter plus d'une quantité de la carte membre à part pour la plein-tarif qui convertit les quantité > 1 en sous-compte
add_filter('woocommerce_cart_item_quantity', 'custom_cart_item_quantity', 10, 3);
function custom_cart_item_quantity($quantity_html, $cart_item_key, $cart_item) {
    //var_dump($cart_item);

    // Vérifie si l'élément du panier est la variation "Sous-compte"
    $premium_product = get_premium_plan_product();

    if ( empty( $premium_plan_product ) ) {
        return;
    }


    if($premium_product == $cart_item['product_id']){
        // Retourne uniquement la quantité sans l'input pour cette variation
        return '<span class="quantity">' . $cart_item['quantity'] . '</span>';
    }

    // Retourne l'affichage par défaut pour les autres articles
    return $quantity_html;
}


// Dans le panier, ajoute les champs d'expédition dans les items de la variation "Sous-compte"
add_action('woocommerce_after_cart_item_name', 'add_shipping_fields_to_cart_item', 10, 2);
function add_shipping_fields_to_cart_item($cart_item, $cart_item_key) {

    // Récupère le produit Carte membre de l'année en cours
    $premium_product = get_premium_plan_product();

    if(!empty($premium_product)){
        // Récupère l'id de la variation sous-compte de l'attribut tarif préférentiel
        $discounted_variation_id = get_variation_by_attribute_value($premium_product, 'attribute_pa_tarif-preferentiel', 'sous-compte');
        $default_variation_id = get_default_variation_id($premium_product);
    }

    // Si $cart_item a la variation plein tarif de la carte membre, on ajoute un bouton sous son titre pour ajouter des sous-comptes
    if (!empty($cart_item['variation_id']) && isset($default_variation_id) && ($default_variation_id == $cart_item['variation_id'])) {
        echo '<button class="toggle-quantity-field button primary small">Ajouter un compte pour un collaborateur</button>';
        echo '<div class="quantity-field-wrapper" style="display:none;">';
        // Champ de type number pour choisir la quantité de sous-comptes à ajouter
        echo '<label for="subaccount_quantity_' . esc_attr($cart_item_key) . '">Quantité de sous-comptes : </label>';
        echo '<input type="number" id="subaccount_quantity_' . esc_attr($cart_item_key) . '" name="subaccount_quantity" min="1" value="1">';
        echo '<button type="button" class="button primary medium add-subaccount-button" data-cart-key="' . esc_attr($cart_item_key) . '" data-variation-id="' . esc_attr($discounted_variation_id) . '">Ajouter des sous-comptes</button>';
        echo '</div>';
    }


    // Si $cart_item correspond à la variation Sous-compte, on ajoute les champs
    if(!empty($cart_item['variation_id']) && isset($discounted_variation_id) && ($discounted_variation_id == $cart_item['variation_id'])){
        echo '<div class="custom-shipping-fields">';

        if(!isset($cart_item['subaccount_data']) || empty(clean_empty_array($cart_item['subaccount_data']))){            
            echo '<button class="toggle-fields button primary small hollow">Configurer le compte collaborateur</button>';
            echo '<div class="fields-wrapper" style="display:none;">';
            echo '<p>"*" signifie que la saisie du champ est obligatoire</p>';
            echo '<p class="form-row form-row-wide validate-required" id="subaccount_data[' . $cart_item_key . '][email_field]" data-priority="10">
                <label for="subaccount_data[' . $cart_item_key . '][email]" class="">Email&nbsp;<abbr class="required" title="obligatoire">*</abbr></label>
                <span class="woocommerce-input-wrapper">
                    <input type="email" class="input-email" name="subaccount_data[' . $cart_item_key . '][email]" id="subaccount_data[' . $cart_item_key . '][email]" placeholder="" value="" aria-required="true" autocomplete="given-name">
                </span>
            </p>';
        
            // Récupère les champs d'expédition
            $shipping_fields = WC()->checkout()->get_checkout_fields('shipping');

            foreach ($shipping_fields as $key => $field) {
                $subaccount_key = 'subaccount_data['.$cart_item_key.'][' . $key . ']';
                woocommerce_form_field($subaccount_key, $field, '');
            }

            echo '</div>';
        }

        echo '</div>';
    }


    // Si le produit mis au panier a la checkbox ACF add_form, on ajoute des champs de formulaire
    $product_id = $cart_item['product_id'];

    if(get_field('add_form', $product_id)){
        echo '<div class="registration-form">';
        
        if(get_field('form_title', $product_id)){
            echo '<h4>'. get_field('form_title', $product_id). '</h4>';
        }
        echo '<p>"*" signifie que la saisie du champ est obligatoire</p>';
        echo '<label for="biennale_data['. $cart_item_key . '][name]">Nom*</label>';
        echo '<input type="text" id="biennale_data['. $cart_item_key . '][name]" name="biennale_data['. $cart_item_key . '][name]" required>';

        echo '<label for="biennale_data['. $cart_item_key . '][first_name]">Prénom*</label>';
        echo '<input type="text" id="biennale_data['. $cart_item_key . '][first_name]" name="biennale_data['. $cart_item_key . '][first_name]" required>';

        echo '<label for="biennale_data['. $cart_item_key . '][institution]">Institution*</label>';
        echo '<input type="text" id="biennale_data['. $cart_item_key . '][institution]" name="biennale_data['. $cart_item_key . '][institution]" required>';

        echo '<label for="biennale_data['. $cart_item_key . '][job]">Fonction*</label>';
        echo '<input type="text" id="biennale_data['. $cart_item_key . '][job]" name="biennale_data['. $cart_item_key . '][job]" required>';

        echo '<label for="biennale_data['. $cart_item_key . '][email]">Email*</label>';
        echo '<input type="email" id="biennale_data['. $cart_item_key . '][email]" name="biennale_data['. $cart_item_key . '][email]" required>';
        
        echo '<label for="biennale_data['. $cart_item_key . '][motivation]">Motivation*</label>';
        echo '<input type="text" id="biennale_data['. $cart_item_key . '][motivation]" name="biennale_data['. $cart_item_key . '][motivation]" required>';
        echo '</div>';
    }
}


/* Gestion AJAX pour ajouter la variation sous-compte avec la quantité définie
 * Dans le panier, lorsqu'il y a une carte membre plein tarif, pour ajouter des sous-compte il y a un input quantité avec un bouton submit qui 
 * envoie une requête AJAX pour ajouter des variations sous-compte dans le panier
 */
add_action('wp_ajax_add_subaccount_variation_to_cart', 'add_subaccount_variation_to_cart');
add_action('wp_ajax_nopriv_add_subaccount_variation_to_cart', 'add_subaccount_variation_to_cart');
function add_subaccount_variation_to_cart() {
    // Récupère le produit Carte membre de l'année en cours
    $premium_product = get_premium_plan_product();    

    if(!empty($premium_product)){
        $premium_product_id = $premium_product->get_id();

        // Récupère l'id de la variation sous-compte de l'attribut tarif préférentiel
        $discounted_variation_id = get_variation_by_attribute_value($premium_product, 'attribute_pa_tarif-preferentiel', 'sous-compte');
    }

    // Vérification de sécurité
    if (!isset($_POST['variation_id'], $_POST['quantity']) || !is_numeric($_POST['quantity'])) {
        wp_send_json_error('Données invalides.');
        return;
    }
        
    $quantity = intval($_POST['quantity']);

    if ($quantity < 1) {
        wp_send_json_error('Quantité invalide.');
        return;
    }

    // Ajout des produits sous-comptes dans le panier
    for ($i = 0; $i < $quantity; $i++) {
        $unique_key = md5(microtime() . rand()); // Permet d'ajouter un produit par ligne plutôt que un seul produit avec une quantité > 1
        WC()->cart->add_to_cart($premium_product_id, 1, $discounted_variation_id, array(), array('unique_key' => $unique_key));
    }

    wp_send_json_success();
}


add_action('wp_ajax_add_cart_meta', 'add_cart_meta');
add_action('wp_ajax_nopriv_add_cart_meta', 'add_cart_meta');
function add_cart_meta(){
    if ( ! wp_verify_nonce( $_POST['security'], 'ajax-nonce' ) ) {
		wp_send_json( array( 'nonce_fail' => 1 ) );
		exit;
	}

    if (empty($_POST['cart_data'])) {
        wp_send_json_error('Aucune donnée reçue.');
    }

    parse_str($_POST['cart_data'], $cart_data);
    
    if(isset($cart_data['subaccount_data']) && !empty(clean_empty_array($cart_data['subaccount_data']))){
        $subaccount_data = $cart_data['subaccount_data'];
        
        $cart_contents = WC()->cart->cart_contents;

        foreach( $cart_contents as $cart_item_id=>$cart_item ) {
            $cart_item_data = $subaccount_data[$cart_item_id];

            if(!empty($cart_item_data)){

                $keys = array('email', 'first_name', 'last_name', 'company', 'country', 'address_1', 'address_2', 'postcode', 'city');
    
                // Récupère dans un tableau pour chaque $keys les valeurs correspondantes
                foreach ($keys as $key) {
                    if($key == 'email'){
                        // Vérifier si un sous-compte utilise une adresse e-mail existante
                        if (email_exists($cart_item_data[$key])) {
                            wc_add_notice('L\'adresse email ' . esc_html($cart_item_data[$key]) . ' est déjà utilisée.', 'error');
                            die;
                        }
                    }
    
                    $matching_values = array_filter($cart_item_data, function($data_key) use ($key) {
                        return strpos($data_key, $key) !== false;
                    }, ARRAY_FILTER_USE_KEY);
    
                    // Ajoute les valeurs au tableau des résultats sous la clé actuelle
                    $cart_item['subaccount_data'][$key] = reset(array_values($matching_values));
                }
    
                WC()->cart->cart_contents[$cart_item_id] = $cart_item;
            }
        }

        WC()->cart->set_session();

    }elseif(isset($cart_data['biennale_data']) && !empty(clean_empty_array($cart_data['biennale_data']))){
        $subaccount_data = $cart_data['biennale_data'];
        
        $cart_contents = WC()->cart->cart_contents;

        foreach( $cart_contents as $cart_item_id=>$cart_item ) {
            $cart_item_data = $subaccount_data[$cart_item_id];

            if(!empty($cart_item_data)){

                $keys = array('first_name', 'name', 'institution', 'job', 'email', 'motivation');
    
                // Récupère dans un tableau pour chaque $keys les valeurs correspondantes
                foreach ($keys as $key) {    
                    $matching_values = array_filter($cart_item_data, function($data_key) use ($key) {
                        return strpos($data_key, $key) !== false;
                    }, ARRAY_FILTER_USE_KEY);
    
                    // Ajoute les valeurs au tableau des résultats sous la clé actuelle
                    $cart_item['biennale_data'][$key] = reset(array_values($matching_values));
                }
    
                WC()->cart->cart_contents[$cart_item_id] = $cart_item;
            }
        }

        WC()->cart->set_session();
    }

    wp_send_json_success();

    exit;
}


/**
 * Lorsque le panier est mis à jour, par exemple si on supprime un produit, 
 * on s'assure qu'il ne reste pas de variation sous-compte s'il n'y a pas 
 * la carte membre plein tarif ou si le client n'est pas déjà Membre parent
 */
add_action('woocommerce_cart_updated', 'validate_cart_for_subaccounts');
function validate_cart_for_subaccounts() {
    // Identifiant du produit parent (Carte membre plein tarif)
    $premium_plan_product = get_premium_plan_product();

    if ( empty( $premium_plan_product ) ) {
        return;
    }
    
    $premium_plan_product_id = get_default_variation_id($premium_plan_product);

    // ID de la variation sous-compte
    $subaccount_variation_id = get_variation_by_attribute_value($premium_plan_product, 'attribute_pa_tarif-preferentiel', 'sous-compte');

    // Récupére le contenu du panier
    $cart = WC()->cart->get_cart();
    $has_parent_product = false;


    // Vérifie si la Carte Membre est dans le panier
    foreach ($cart as $cart_item_key => $cart_item) {
        if ($cart_item['variation_id'] == $premium_plan_product_id) {
            $has_parent_product = true;
            break;
        }
    }

    if(is_user_logged_in()){
        $current_user = wp_get_current_user();

        if(has_premium_plan($current_user->ID) && in_array( 'member_role', $current_user->roles )){
            $has_parent_product = true;
        }
    }

    $show_error = false;

    // Si le produit parent n'est pas dans le panier, supprimer les variations sous-compte
    if (!$has_parent_product) {
        foreach ($cart as $cart_item_key => $cart_item) {
            if ($cart_item['variation_id'] == $subaccount_variation_id) {
                WC()->cart->remove_cart_item($cart_item_key);
                $show_error = true;
            }
        }
    }

    if($show_error){
        wc_add_notice(
            'Vous devez avoir ' . $premium_plan_product->get_name()  . ' dans votre panier pour pouvoir commander un sous-compte.',
            'error'
        );
    }
}


// Met à jour les prix après avoir supprimé un produit
/* add_action('template_redirect', 'update_cart_items_after_removal');
function update_cart_items_after_removal() {
    // Vérifier la présence du paramètre `?removed_item=1`
    if (isset($_GET['removed_item']) && $_GET['removed_item'] == 1) {
        $cart_length = count(WC()->cart->get_cart());
        $empty_child_length = get_empty_child_account();

        if($cart_length <= $empty_child_length){
            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                if(!empty($empty_child_length) && $empty_child_length > 0){
                    WC()->cart->cart_contents[$cart_item_key]['subaccount_data']['empty_child_account'] = true;
                }
                
                $empty_child_length--;
            }
        }
        
        // Sauvegarder les modifications dans la session
        WC()->cart->set_session();
        WC()->cart->calculate_totals();

        // Rediriger pour nettoyer l'URL
        wp_safe_redirect(remove_query_arg('removed_item'));
        exit;
    }
} */