<?php
// Transfère les données des sous-comptes du panier à la commande
add_action('woocommerce_checkout_create_order_line_item', 'add_subaccount_data_to_order', 10, 4);
function add_subaccount_data_to_order($item, $cart_item_key, $values, $order) {
    if (isset($values['subaccount_data'])) {
        $item->add_meta_data('subaccount_data', $values['subaccount_data'], true);
    }

    if (isset($values['biennale_data'])) {
        $item->add_meta_data('biennale_data', $values['biennale_data'], true);
    }
}


// Dans la page checkout, on met à jour la TVA suivant le pays sélectionné dans les champs de facturation
add_action( 'wp_footer', 'update_tax_based_on_billing_country' );
function update_tax_based_on_billing_country() {
    if ( is_checkout() ) : ?>
        <script type="text/javascript">
            jQuery(function($) {
                $('#billing_country').on('change', function() {
                    // Forcer la mise à jour du panier
                    $('body').trigger('update_checkout');
                });
            });
        </script>
    <?php endif;
}


add_action( 'woocommerce_cart_calculate_fees', 'adjust_total_tax_based_on_billing_country', 20, 1 );
function adjust_total_tax_based_on_billing_country( $cart ) {
    
    // Récupère le pays de facturation actuel
    $billing_country = WC()->customer->get_billing_country();
    $shipping_country = WC()->customer->get_shipping_country();
    $billing_is_company = WC()->session->get('billing_is_company');

    // S'il y a une liste de pays OCDE dans l'admin, on la parcourt et vérifie que $billing_country et $shipping_country n'en font pas parti, sinon on affiche une erreur
    if(!empty(clean_empty_array(get_field('countries_list', 'options')))){
        $countries_list = get_field('countries_list', 'options');
        $country_codes = array_column($countries_list, 'country_code');
        
        $restricted_product_in_cart = false;
        foreach ( $cart->get_cart() as $cart_item ) {
            $product = $cart_item['data'];

            // Vérifie si le produit est une variation et possède l'attribut "Tarif préférentiel" avec la valeur "Pays hors OCDE"
            if ( $product->is_type('variation') ) {
                
                $attributes = $product->get_attributes();

                if ( isset($attributes['pa_tarif-preferentiel']) && $attributes['pa_tarif-preferentiel'] === 'pays-hors-ocde' ) {
                    $restricted_product_in_cart = true;
                    //break;
                }
            }
        }

        $message = get_field( 'country_error', 'options' ) != '' ? get_field( 'country_error', 'options' ) : __( 'Vous ne pouvez pas sélectionner ce pays de facturation ou livraison avec cette déclinaison de produit', 'ocim' );
        $notices = wc_get_notices('error');
       

        /*
         * Si le produit avec la variation "Pays hors OCDE" est dans le panier et 
         * qu'un pays dans la facturation ou livraison ne fait pas parti de la liste $country_codes, on affiche une erreur
         */
        if ( $restricted_product_in_cart && !in_array( $billing_country, $country_codes ) && !in_array( $shipping_country, $country_codes ) ) {
            // Supprime uniquement la notice d'erreur spécifique aux pays interdits
            foreach ( $notices as $key => $notice ) {
                if ( strpos( $notice['notice'], $message ) !== false ) {
                    unset( $notices[$key] );
                }
            }
            wc_set_notices( [ 'error' => $notices ] );
        }else{
            if(isset($notices) && !empty($notices)){
                foreach ( $notices as $key => $notice ) {
                    if ( strpos( $notice['notice'], $message ) == false ) {
                        wc_add_notice( $message, 'error' );
                    }
                }
            }
        }
    }


    // Applique la TVA sur les frais de transport si le pays de facturation n'est pas la France et que ce n'est pas une entreprise
    if ( $billing_country !== 'FR' && !$billing_is_company ) {
        $shipping_tax_name = get_option('woocommerce_shipping_tax_class'); // Récupère le nom de la tva appliqué sur l'expédition
        $shipping_tax_rate = get_tax_rate_by_name($shipping_tax_name); // Récupère le pourcentage de TVA

        $shipping_total = $cart->get_shipping_total(); // Récupère le montant d'expédition
        $shipping_tax = $shipping_total * ($shipping_tax_rate/100); // Calcul le montant de TVA sur les frais de transport

        if($shipping_tax){
            $cart->add_fee( __('TVA sur les frais de transport', 'ocim'), $shipping_tax );
        }
    }
}


// Ajouter les champs pour l'entreprise à la page de checkout
add_filter( 'woocommerce_checkout_fields', 'add_custom_checkout_fields' );
function add_custom_checkout_fields( $fields ) {
    $new_fields = array();

    foreach ($fields['billing'] as $key => $field) {
        if ($key === 'billing_company') {

            // Ajouter nos champs personnalisés avant le champ 'billing_company'
            $new_fields['billing_is_company'] = array(
                'type'      => 'checkbox',
                'label'     => __('Cocher cette case si vous êtes une institution, une université, une organisation publique ou une société privée', 'ocim'),
                'required'  => false,
                'class'     => array('form-row-wide'),
                'clear'     => true
            );

            $new_fields['billing_siret'] = array(
                'type'      => 'text',
                'label'     => __('SIRET', 'ocim'),
                'required'  => false,
                'class'     => array('form-row-wide'),
                'clear'     => true
            );

            $new_fields['billing_taxe_intra'] = array(
                'type'      => 'text',
                'label'     => __('Numéro de TVA intracommunautaire', 'ocim'),
                'required'  => false,
                'class'     => array('form-row-wide'),
                'clear'     => true
            );

            $new_fields['billing_type_activite'] = array(
                'type'      => 'text',
                'label'     => __('Nature de l\'activité', 'ocim'),
                'required'  => false,
                'class'     => array('form-row-wide'),
                'clear'     => true
            );

            // Modifier le champ 'billing_company' pour le rendre optionnel et caché par défaut
            $field['class'][] = 'hidden';
            $field['required'] = false;
        }

        // Ajouter le champ original (ou modifié)
        $new_fields[$key] = $field;
    }

    if ( has_specific_variation_in_cart('etudiant-demandeur-demploi') ) {
        $new_fields['billing_justif'] = array(
            'type' => 'file',
            'label' => __('Justificatif (Ex : Carte étudiante, Attestation France Travail)', 'ocim'),
            'class' => array('form-row-wide'),
            'required' => true,
            'max_size'  => '5120', // in ko (here 5 Mo size limit)
            'accept'    => '.png, .jpg, .jpeg, .pdf', // Image files only
            'priority' => 200,
        );
    }

    $fields['billing'] = $new_fields;

    return $fields;
}


// On billing or shipping section, when "upload" field is required
add_action( 'woocommerce_after_checkout_validation', 'custom_after_checkout_validation', 20, 2 );
function custom_after_checkout_validation($data, $errors) {
    $field_key = 'billing_justif'; // Here define the field key (or field ID)

    $errors->remove($field_key.'_required'); // Remove unwanted error for input file

    // Affiche une erreur si les champs entreprises sont vides
    if (!empty($data['billing_is_company'])) {
        if (empty($data['billing_company'])) {
            $errors->add('validation', __('Le champ "Nom de l\'entreprise" est obligatoire.', 'ocim'));
        }
        if (empty($data['billing_siret'])) {
            $errors->add('validation', __('Le champ "SIRET" est obligatoire.', 'ocim'));
        }
        if (empty($data['billing_taxe_intra'])) {
            $errors->add('validation', __('Le champ "Numéro de TVA intracommunautaire" est obligatoire.', 'ocim'));
        }
        if (empty($data['billing_type_activite'])) {
            $errors->add('validation', __('Le champ "Type d\'activité" est obligatoire.', 'ocim'));
        }
    }
}


// Required upload field validation
add_action( 'woocommerce_checkout_process', 'checkout_required_upload_validation' );
function checkout_required_upload_validation() {
    if ( has_specific_variation_in_cart('etudiant-demandeur-demploi') ) {
        $checkout_upload = WC()->session->get('checkout_upload');
        if( empty( $checkout_upload ) ) {
            wc_add_notice( __('Vous devez fournir un justificatif pour pouvoir commander', 'ocim'), 'error' ); // Displays an error notice
        }
    }
}


// Sauvegarder les champs personnalisés dans la commande
add_action( 'woocommerce_checkout_update_order_meta', 'save_custom_checkout_fields' );
function save_custom_checkout_fields( $order_id ) {    
    if ( isset($_POST['billing_is_company']) ) {
        update_post_meta( $order_id, 'billing_is_company', sanitize_text_field( $_POST['billing_is_company'] ) );
    }
    if ( ! empty( $_POST['billing_siret'] ) ) {
        update_post_meta( $order_id, 'billing_siret', sanitize_text_field( $_POST['billing_siret'] ) );
    }
    if ( ! empty( $_POST['billing_taxe_intra'] ) ) {
        update_post_meta( $order_id, 'billing_taxe_intra', sanitize_text_field( $_POST['billing_taxe_intra'] ) );
    }
    if ( ! empty( $_POST['billing_type_activite'] ) ) {
        update_post_meta( $order_id, 'billing_type_activite', sanitize_text_field( $_POST['billing_type_activite'] ) );
    }


    if (isset($_POST['ocim_justif'])) {
		$file = unserialize(urldecode($_POST['ocim_justif']));
		$get_dir = dirname($file['file']);
		$temp_filename = basename($file['file']);
		$strname = explode('xxx_', $file['file']);

		$new_filename = $order_id . '_' . $strname['3'];

		rename($file['file'], $get_dir . '/' . $new_filename);

		$file['file'] = str_replace($temp_filename, $new_filename, $file['file']);
		$file['url'] = str_replace($temp_filename, $new_filename, $file['url']);

		update_post_meta($order_id, 'ocim_justif', urlencode(serialize($file)));
	}
}


// Afficher les champs personnalisés dans l'administration de la commande
add_action( 'woocommerce_admin_order_data_after_billing_address', 'display_custom_fields_in_admin', 10, 1 );
function display_custom_fields_in_admin( $order ) {
    $is_company = get_post_meta( $order->get_id(), 'billing_is_company', true );
    $siret = get_post_meta( $order->get_id(), 'billing_siret', true );
    $taxe_intra = get_post_meta( $order->get_id(), 'billing_taxe_intra', true );
    $type_activite = get_post_meta( $order->get_id(), 'billing_type_activite', true );
    $bon_commande = get_post_meta( $order->get_id(), 'ocim_bdc', true );
    $justif = get_post_meta( $order->get_id(), 'ocim_justif', true );

    if ( $is_company ) {
        echo '<p><strong>' . __( 'Entreprise', 'ocim' ) . ':</strong> ' . __( 'Oui', 'ocim' ) . '</p>';
    }
    if ( $siret ) {
        echo '<p><strong>' . __( 'SIRET', 'ocim' ) . ':</strong> ' . $siret . '</p>';
    }
    if ( $taxe_intra ) {
        echo '<p><strong>' . __( 'Numéro de TVA intracommunautaire', 'ocim' ) . ':</strong> ' . $taxe_intra . '</p>';
    }
    if ( $type_activite ) {
        echo '<p><strong>' . __( 'Type d\'activité', 'ocim' ) . ':</strong> ' . $type_activite . '</p>';
    }
    if ( ! empty( $bon_commande ) ) {
        $bon_url = unserialize(urldecode($bon_commande))["url"];

        if(!empty($bon_url)){
            echo '<p class="custom-payment-info">';
            echo sprintf(
                __( '<strong>Bon de commande :</strong> <a href="%s" target="_blank" class="button primary medium">Voir le bon</a>', 'ocim' ),
                esc_url( $bon_url )
            );
            echo '</p>';
        }
    }

    // Si la métadonnée existe, afficher le lien
    if ( ! empty( $justif ) ) {
        $justif_url = unserialize(urldecode($justif))["url"];

        if(!empty($justif_url)){
            echo '<p class="custom-payment-info">';
            echo sprintf(
                __( '<strong>Justificatif :</strong> <a href="%s" target="_blank" class="button primary medium">Voir le justificatif</a>', 'ocim' ),
                esc_url( $justif_url )
            );
            echo '</p>';
        }
    }
}


// Met à jour les meta de $user avec les champs billing_is_company, billing_siret, billing_taxe_intra
add_action( 'woocommerce_checkout_update_user_meta', 'save_custom_fields_to_user_meta' );
function save_custom_fields_to_user_meta( $customer_id ) {
    if ( isset($_POST['billing_is_company']) ) {
        update_user_meta( $customer_id, 'billing_is_company', sanitize_text_field( $_POST['billing_is_company'] ) );
    }
    if ( ! empty( $_POST['billing_siret'] ) ) {
        update_user_meta( $customer_id, 'billing_siret', sanitize_text_field( $_POST['billing_siret'] ) );
    }
    if ( ! empty( $_POST['billing_taxe_intra'] ) ) {
        update_user_meta( $customer_id, 'billing_taxe_intra', sanitize_text_field( $_POST['billing_taxe_intra'] ) );
    }
}


function add_quote_button_to_checkout() {
    $coupons = WC()->cart->get_applied_coupons();

    // S'il n'y a pas de coupon de réduction, on peut afficher le bouton de demande de devis
    if (empty($coupons)) {
        echo '<div id="quote-button-wrapper" class="mt-2">';
        echo '<h3 id="quote-title" class="mt-3">Que souhaitez-vous faire ?</h3>';
        echo '<div class="button-wrapper align-middle">';
        echo '<h4 class="mr-2 mb-0">Demander un devis</h4>';
        echo '<div id="generate-quote-btn" class="button mb-0"><div class="bouton-cyan"></div>Générer un devis</div>';
        echo '</div></div>';
        echo '<h4 class="mt-2">Payer</h4> ';
    }
}
add_action('woocommerce_review_order_before_payment', 'add_quote_button_to_checkout');


function justif_upload_dir($dir){
	return array(
		'path'   => $dir['basedir'] . '/justificatifs/' . date('Y') . '/' . date('m'),
		'url'    => $dir['baseurl'] . '/justificatifs/' . date('Y') . '/' . date('m'),
		'subdir' => '/justificatifs',
	) + $dir;
}


function has_specific_variation_in_cart($variation_slug) {
    // Boucle sur le panier
    foreach ( WC()->cart->get_cart() as $cart_item ) {
        $product = $cart_item['data'];

        // Vérifier si c'est une variation de produit
        if ( $product->is_type( 'variation' ) ) {
            // Obtenir les attributs de la variation
            $variation_attributes = $product->get_variation_attributes();

            // Vérifier si l'attribut tarif-preferentiel correspond au slug passé en paramètre
            if ( isset( $variation_attributes['attribute_pa_tarif-preferentiel'] ) && $variation_attributes['attribute_pa_tarif-preferentiel'] === $variation_slug ) {
                return true;
            }
        }
    }
    return false;
}


add_action('woocommerce_checkout_update_order_review', 'update_cart_based_on_company_and_country');
function update_cart_based_on_company_and_country($posted_data) {
    parse_str($posted_data, $form_data);

    // Récupérer les champs Entreprise et Pays
    $billing_company = isset($form_data['billing_company']) ? $form_data['billing_company'] : '';
    $billing_country = isset($form_data['billing_country']) ? $form_data['billing_country'] : '';

    // Vérifie si la case Entreprise est cochée
    $billing_is_company = isset($form_data['billing_is_company']) ? $form_data['billing_is_company'] : '';
    
    // Mettre à jour les informations du client
    WC()->customer->set_billing_company($billing_company);
    WC()->customer->set_billing_country($billing_country);
    
    WC()->session->set('billing_is_company', $billing_is_company);    

    WC()->cart->calculate_shipping();
    WC()->cart->calculate_totals();
}


// Affiche les prix TTC partout, peu importe le pays de facturation
add_filter( 'woocommerce_adjust_non_base_location_prices', '__return_false' );


add_filter('woocommerce_cart_totals_order_total_html', 'display_checkout_total_excluding_tax', 10, 1);
function display_checkout_total_excluding_tax($value) {
    // Si c'est un pays autre que la France et Monaco
    if(tva_to_zero()){
        return WC()->cart->get_total();
    }

    // Retourner le total avec TVA si les conditions ne sont pas remplies
    return $value;
}


// Vérifie si un coupon de réduction est appliqué, si c'est le cas, on laisse que le paiement par carte
add_filter('woocommerce_available_payment_gateways', 'custom_restrict_payment_methods_based_on_coupon');
function custom_restrict_payment_methods_based_on_coupon($available_gateways) {
    if (is_checkout() && WC()->cart) {
        $coupons = WC()->cart->get_applied_coupons();

        // Vérifie si un coupon est appliqué
        if (isset($coupons) && !empty($coupons)) {
            // S'il y a un coupon autre que "test", on laisse que le moyen de paiement par CB
            //if(!in_array('test', $coupons)){ // Pour les tests en préprod il y a un coupon test
                foreach ($available_gateways as $gateway_id => $gateway) {
                    // Conserve que le paiement par carte bancaire
                    if ($gateway_id !== 'payplug') {
                        unset($available_gateways[$gateway_id]);
                    }
                }
            //}
        }
    }

    return $available_gateways;
}


// Récupère les coupons de réductions appliqués dans le panier (sert à masquer le bouton de demande de devis)
function get_applied_coupons_ajax() {
    $coupons = WC()->cart->get_applied_coupons();
    wp_send_json($coupons);
}
add_action('wp_ajax_get_applied_coupons', 'get_applied_coupons_ajax');
add_action('wp_ajax_nopriv_get_applied_coupons', 'get_applied_coupons_ajax');


// Si dans le panier il y a l'abonnement (et seulement ce produit), on passe les frais de livraison à 0€
add_filter('woocommerce_package_rates', function($rates, $package) {
    // On récupère le produit lié au plan Carte membre
    $premium_product = get_premium_plan_product();

    if ( empty( $premium_product ) ) {
        return;
    }

    $premium_product_id = $premium_product->get_id();
    $free_shipping = true;

    foreach ($package['contents'] as $cart_item) {
        if ($cart_item['product_id'] != $premium_product_id) {
            $free_shipping = false;
            break;
        }
    }

    if ($free_shipping) {
        foreach ($rates as $rate_id => $rate) {
            $rates[$rate_id]->cost = 0; // Appliquer un tarif de 0€

            // Réinitialiser les taxes (TVA)
            $rates[$rate_id]->taxes = array(); // Réinitialise les taxes, y compris la TVA
        }
    }

    return $rates;
}, 10, 2);


// checkbox Conditions générales : supprime les conditions qui s'affichent quand on clique sur le lien.
add_action( 'wp', function() {
	remove_action( 'woocommerce_checkout_terms_and_conditions', 'wc_terms_and_conditions_page_content', 30 );
});