<?php
// Add Input File type to WooCommerce form fields
add_filter( 'woocommerce_form_field', 'woocommerce_form_input_field_type_file', 10, 4 );
function woocommerce_form_input_field_type_file( $field, $key, $args, $value ){
    if( $args['type'] === 'file' && is_checkout() && ! is_wc_endpoint_url() ){
        if ( $args['required'] ) {
            $args['class'][] = 'validate-required';
            $required        = '&nbsp;<abbr class="required" title="' . esc_attr__( 'required', 'woocommerce' ) . '">*</abbr>';
        } else {
            $required = '&nbsp;<span class="optional">(' . esc_html__( 'optional', 'woocommerce' ) . ')</span>';
        }
        $field           = '';
        $label_id        = $args['id'];
        $sort            = $args['priority'] ? $args['priority'] : '';
        $field_container = '<p class="form-row %1$s" id="%2$s" data-priority="' . esc_attr( $sort ) . '">%3$s</p>';
        $max_size        = isset($args['max_size']) ? 'data-max_size="' . intval( $args['max_size'] ) . '" ' : '';
        $accept          = isset($args['accept']) ? 'accept="' . esc_attr( $args['accept'] ) . '" ' : '';
        
        $field .= sprintf( '<input type="%s" class="input-file %s" name="%s" id="%s" %s/>', esc_attr( $args['type'] ), 
            esc_attr( implode( ' ', $args['input_class'] ) ), esc_attr( $key ), esc_attr( $args['id'] ), $max_size . $accept );

        if ( ! empty( $field ) ) {
            $field_html = '<label for="' . esc_attr( $label_id ) . '" class="' . esc_attr( implode( ' ', $args['label_class'] ) ) . '">' . wp_kses_post( $args['label'] ) . $required . '</label>';
            $field_html .= '<span class="woocommerce-input-wrapper">' . $field;

            if ( $args['description'] ) {
                $field_html .= '<span class="description" id="' . esc_attr( $args['id'] ) . '-description" aria-hidden="true">' . wp_kses_post( $args['description'] ) . '</span>';
            }

            $field_html .= '<span class="upload-response" style="display:none"></span></span>';

            $container_class = esc_attr( implode( ' ', $args['class'] ) );
            $container_id    = esc_attr( $args['id'] ) . '_field';
            $field           = sprintf( $field_container, $container_class, $container_id, $field_html );
        }
    }
    return $field;
}


// PHP Ajax responder
add_action( 'wp_ajax_checkout_upload', 'checkout_ajax_file_upload' );
add_action( 'wp_ajax_nopriv_checkout_upload', 'checkout_ajax_file_upload' );
function checkout_ajax_file_upload(){

    if ( ! wp_verify_nonce( $_POST['nonce'], 'ajax-nonce' ) ) {
		wp_send_json( array( 'nonce_fail' => 1 ) );
		exit;
	}

    $_SESSION['token'] = uniqid();
	if (isset($_FILES['file'])) {
		$name = $_FILES['file']['name'];
		$type = $_FILES['file']['type'];
		$url = ($_FILES['file']['tmp_name']);
		$error = $_FILES['file']['error'];
		$size = ($_FILES['file']['size']);
		$_FILES['file'] = array('name' => 'xxx_tempxxx_' . $_SESSION["token"] . 'xxx_' . $name, 'type' => $type, 'tmp_name' => $url, 'error' => $error, 'size' => $size);

		$filesdetail = $_FILES['file'];
		if (! function_exists('wp_handle_upload')) {
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}

		add_filter('upload_dir', 'justif_upload_dir');
		$file_return = wp_handle_upload($filesdetail, array(
			'test_form' => false,
			'mimes' => get_allowed_mime_types()
		));
		remove_filter('upload_dir', 'justif_upload_dir');
		$file_return['token'] = $_SESSION['token'];

		if (isset($file_return['error'])) {
			echo ($file_return['error']);
			echo ('<input type="hidden" name="ocim_justif" value="">');
		} else {
			echo ('<a target="_blank" href="' . $file_return['url'] . '">' . $name . '</a><input type="hidden" name="ocim_justif" value="' . urlencode(serialize($file_return)) . '">');

            WC()->session->set('checkout_upload', urlencode(serialize($file_return)));
		}

		wp_die(); // ajax call must die to avoid trailing 0 in your response
	}

	wp_die();
}