<?php

// Créer des colonnes pour le fichiers d'export
add_filter('wc_memberships_csv_export_user_memberships_headers', function($headers ){
    // Ajoute du colonne pour l'adresse de facturation et de livraison
    $headers['addresse_facturation'] = 'addresse_facturation';
    $headers['addresse_facturation_2'] = 'addresse_facturation_2';
    $headers['code_postal_facturation'] = 'code_postal_facturation';
    $headers['ville_facturation'] = 'ville_facturation';
    $headers['pays_facturation'] = 'pays_facturation';
    $headers['nom_livraison'] = 'nom_livraison';
    $headers['prenom_livraison'] = 'prenom_livraison';
    $headers['entreprise_livraison'] = 'entreprise_livraison';
    $headers['addresse_livraison'] = 'addresse_livraison';
    $headers['addresse_livraison_2'] = 'addresse_livraison_2';
    $headers['code_postal_livraison'] = 'code_postal_livraison';
    $headers['ville_livraison'] = 'ville_livraison';
    $headers['pays_livraison'] = 'pays_livraison';
    return $headers;
}, 10, 3);


// Rempli ces colonnes avec les données
add_filter('wc_memberships_csv_export_user_memberships_row', function($row, $user_membership) {
    $user_id = $row['user_id'];

    $countries = WC()->countries->get_countries();
    
    // Récupère l'adresse de facturation du client et l'ajoute à la ligne courante dans le csv
    if(!empty(get_user_meta($user_id, 'billing_address_1', true))){
        $row['addresse_facturation'] = get_user_meta($user_id, 'billing_address_1', true);
    }
    if(!empty(get_user_meta($user_id, 'billing_address_2', true))){
        $row['addresse_facturation_2'] = get_user_meta($user_id, 'billing_address_2', true);
    }
    if(!empty(get_user_meta($user_id, 'billing_postcode', true))){
        $row['code_postal_facturation'] = get_user_meta($user_id, 'billing_postcode', true);
    }
    if(!empty(get_user_meta($user_id, 'billing_city', true))){
        $row['ville_facturation'] = get_user_meta($user_id, 'billing_city', true);
    }
    if(!empty(get_user_meta($user_id, 'billing_country', true))){
        $billing_country_code = get_user_meta($user_id, 'billing_country', true);
        $billing_country_name = isset($countries[$billing_country_code]) ? $countries[$billing_country_code] : $billing_country_code;
        $row['pays_facturation'] = $billing_country_name;
    }
    
    // Récupère l'adresse de livraison du client et l'ajoute à la ligne courante dans le csv
    if(!empty(get_user_meta($user_id, 'shipping_last_name', true))){
        $row['nom_livraison'] = get_user_meta($user_id, 'shipping_last_name', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_first_name', true))){
        $row['prenom_livraison'] = get_user_meta($user_id, 'shipping_first_name', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_company', true))){
        $row['entreprise_livraison'] = get_user_meta($user_id, 'shipping_company', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_address_1', true))){
        $row['addresse_livraison'] = get_user_meta($user_id, 'shipping_address_1', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_address_1', true))){
        $row['addresse_livraison'] = get_user_meta($user_id, 'shipping_address_1', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_address_2', true))){
        $row['addresse_livraison_2'] = get_user_meta($user_id, 'shipping_address_2', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_postcode', true))){
        $row['code_postal_livraison'] = get_user_meta($user_id, 'shipping_postcode', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_city', true))){
        $row['ville_livraison'] = get_user_meta($user_id, 'shipping_city', true);
    }
    if(!empty(get_user_meta($user_id, 'shipping_country', true))){
        $shipping_country_code = get_user_meta($user_id, 'shipping_country', true);
        $shipping_country_name = isset($countries[$shipping_country_code]) ? $countries[$shipping_country_code] : $shipping_country_code;
        $row['pays_livraison'] = $shipping_country_name;
    }

    return $row;
}, 10, 2);