<?php
use Dompdf\Dompdf;
   
add_action('wp_ajax_generate_quote_pdf', 'generate_quote_pdf');
add_action('wp_ajax_nopriv_generate_quote_pdf', 'generate_quote_pdf');

function generate_quote_pdf() {
    if (empty($_POST['checkout_data'])) {
        wp_send_json_error('Aucune donnée reçue.');
    }

    // Inclure les fichiers nécessaires
    require_once ABSPATH . 'wp-load.php';
    require_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-cart-functions.php';
    require_once ABSPATH . 'wp-content/plugins/woocommerce/includes/wc-notice-functions.php';

    // Récupération des données du checkout
    parse_str($_POST['checkout_data'], $checkout_data);
    $cart = WC()->cart;

    // Créations de variables qui vont remplacer celles dans le template de pdf
    $vars = array();

    $vars['quote_number'] = generate_quote_number();

    $vars['header_img'] = IMG_DIR . '/header-pdf.jpg';
    $vars['logo_ocim'] = IMG_DIR . '/Logo_Ocim_Boutique.png';
    $vars['footer_img'] = IMG_DIR . '/footer-pdf.jpg';

    $vars['date'] = date("d/m/Y");

    // Génération du contenu PDF
    $user = '<p>Nom : ' . esc_html($checkout_data['billing_first_name'] . ' ' . $checkout_data['billing_last_name']) . '</p>';
    $user .= '<p>Téléphone : ' . esc_html($checkout_data['billing_phone']) . '</p>';
    $user .= '<p>Email : ' . esc_html($checkout_data['billing_email']) . '</p>';
    $user .= '<p>Adresse : ' . esc_html($checkout_data['billing_address_1']) . '</p>';
    $user .= '<p>Code postal : ' . esc_html($checkout_data['billing_postcode']) . '</p>';
    $user .= '<p>Ville : ' . esc_html($checkout_data['billing_city']) . '</p>';

    $country_code = $checkout_data['billing_country'];
    $countries = WC()->countries->get_countries();
    $country_name = isset($countries[$country_code]) ? $countries[$country_code] : $country_code;

    $user .= '<p>Pays : ' . $country_name . '</p>';
    
    if(!empty($checkout_data['billing_siret'])){
        $user .= '<p>Entreprise : ' . $checkout_data['billing_company'] . '</p>';
    }
    if(!empty($checkout_data['billing_taxe_intra'])){
        $user .= '<p>Taxe intrac. : ' . $checkout_data['billing_taxe_intra'] . '</p>';
    }
    if(!empty($checkout_data['billing_siret'])){
        $user .= '<p>SIRET : ' . $checkout_data['billing_siret'] . '</p>';
    }
    if(!empty($checkout_data['billing_type_activite'])){
        $user .= '<p>Nature de l\'activité : ' . $checkout_data['billing_type_activite'] . '</p>';
    }

    $vars['user'] = $user;

    $vars['cart'] = '';
    $vars['tva_table'] = '';
    $total_cart = 0;
    $total_tax_amount = 0;

    foreach ($cart->get_cart() as $cart_item) {
        $product = $cart_item['data'];

        if ( $product->is_taxable() ) {
            // Si le pays de facturation est la France ou Monaco, on distingue le prix HT du TTC
            if(!tva_to_zero($country_code)){

                // Récupère le prix HT total pour la quantité de produits dans la ligne
                $price_without_tax = wc_get_price_excluding_tax( $product, array( 'qty' => $cart_item['quantity'] ) );
            
                $tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
    
                // Récupère le taux de TVA pour le produit        
                $tax_rate = array();
                
                // S'il y une TVA standard appliquée au produit, on la récupère avec get_rates_for_tax_class()
                if(empty( $tax_rates)){
                    if($country_code == 'FR'){
                        $tax_rate = get_default_tax_rate();
                    }else{
                        $tax_rate['rate'] = 0;
                    }
                }else{
                    $tax_rate = reset( $tax_rates ); // Prend le premier taux de TVA applicable
                }
                
                $tax_percentage = isset( $tax_rate['rate'] ) ? floatval($tax_rate['rate']) : 0;
                $price_with_tax = $price_without_tax * ( 1 + $tax_percentage / 100 );
                $tax_amount = $price_with_tax - $price_without_tax;
                $total_tax_amount += $tax_amount;
            }else{
                $tax_percentage = 0;
                $price_with_tax = $product->get_price() * $cart_item['quantity'];
                $price_without_tax = $price_with_tax;
                $tax_amount = 0;
                $total_tax_amount += $tax_amount;
            }
        }

        $total_cart += $price_without_tax;

        // Ajoute le produit au tableau de produits
        $vars['cart'] .= '<tr><td>' . $product->get_name() . '</td><td style="text-align:center;">' . $cart_item['quantity'] . '</td><td style="text-align:center;">' . wc_price($price_without_tax) . '</td><td style="text-align:center;">' . $tax_percentage . '%</td></td></tr></p>';
        
        // Ajoute les taxes de ce produit dans le tableau des taxes
        $vars['tva_table'] .= '<tr><td>' . $tax_percentage . '%</td><td>' . wc_price($price_without_tax) . '</td><td>' . wc_price($tax_amount) . '</td></tr>';
    }


    // Partie Expédition
    $shipping_total = floatval(WC()->cart->get_shipping_total()); // Frais d'expédition HT
    $shipping_with_tax = 0;

    if(!empty($shipping_total)){
        $shipping_tax_name = get_option('woocommerce_shipping_tax_class'); // Récupère le nom de la tva appliqué sur l'expédition
        $shipping_tax_rate = get_tax_rate_by_name($shipping_tax_name); // Récupère le pourcentage de TVA
        $shipping_with_tax = $shipping_total * ( 1 + $shipping_tax_rate / 100 ); // Calcul l'expédition TTC
    
        // Ajoute l'expédition dans le tableau de produits
        $vars['cart'] .= '<tr><td>Expédition</td><td></td><td style="text-align:center;">' . wc_price($shipping_total) . '</td><td style="text-align:center;">' . $shipping_tax_rate   . '%</td></tr>';
        
        // Ajoute l'expédition dans le tableau des taxes
        $vars['tva_table'] .= '<tr><td>' . $shipping_tax_rate . '%</td><td>' . wc_price($shipping_total) . '</td><td>' . wc_price(($shipping_with_tax - $shipping_total)) . '</td></tr>';
    }


    // Partie totaux
    $vars['total_ht']  = wc_price($total_cart + $shipping_total);//wc_price((floatval($cart->subtotal_ex_tax) + $shipping_total));
    $vars['total_tva'] = wc_price($total_tax_amount + array_sum(WC()->cart->get_shipping_taxes()));
    $vars['total_ttc'] = $cart->get_total();

    $templatePdf = file_get_contents(get_template_directory() . "/inc/woocommerce/html_to_pdf_quote.html");

    foreach($vars as $key => $value){
        $templatePdf = str_replace('{{ '.$key.' }}', $value, $templatePdf);
    }


    // Générer le PDF
    require get_template_directory() . '/vendor/autoload.php';
    
    $dompdf = new Dompdf(array(
        'enable_remote' => true,
        'chroot' => array(
            get_template_directory() . '/dist/images'
        )
    ));
    $dompdf->loadHtml($templatePdf);
    $dompdf->render();

    // Sauvegarder le fichier PDF temporairement
    $upload_dir = wp_upload_dir();
    $pdf_path = $upload_dir['basedir'] . '/devis/devis-' . $vars['quote_number'] . '.pdf';
    file_put_contents($pdf_path, $dompdf->output());

    // Envoyer le PDF par e-mail
    $to = $checkout_data['billing_email'];

    // Si l'email renseigné pour la facture est un mail propulse, on ne l'envoie pas à Ocim
    $is_propulse_email = strpos($to, '@propulse.fr') !== false;

    if (!$is_propulse_email) {
        $to .= ',boutique.ocim@ube.fr';
    }
    
    $subject = 'Votre demande de devis sur la boutique de l\'Ocim';
    
    $message = 'Merci pour votre demande. Veuillez trouver ci-joint votre devis.<br>';
    $message .= 'Si vous l\'acceptez, merci de confirmer votre commande sur <a href="https://boutique.ocim.fr/accueil-boutique/">https://boutique.ocim.fr/accueil-boutique/</a>.<br>';
    $message .= 'Vous avez une question ? N’hésitez pas à nous en faire part en nous contactant à l\'adresse <a href="mailto:boutique.ocim@ube.fr">boutique.ocim@ube.fr</a>.<br><br>';
    $message .= 'L\'équipe de l\'Ocim';

    $headers = array(
        'From: OCIM <boutique.ocim@ube.fr>',
        'Content-Type: text/html; charset=UTF-8'
    );

    if(wp_mail($to, $subject, $message, $headers, $pdf_path)){
        // Retournez une réponse JSON
        wp_send_json_success(['message' => __('Devis généré avec succès', 'ocim')]);
    }else{
        wc_add_notice(__('Une erreur s\'est produite lors de la création de votre devis. Veuillez réessayer.', 'ocim'), 'error');
        wp_send_json_error(['message' => __('Une erreur s\'est produite lors de la création de votre devis. Veuillez réessayer.', 'ocim')]);
    }

    // Retourner une réponse
    //unlink($pdf_path); // Supprimer le fichier temporaire
    wp_send_json_success('Devis généré avec succès.');
}


// Créé une table dans la bdd pour créer les numéros de devis
add_action('after_setup_theme', 'create_quote_table');
function create_quote_table() {
    global $wpdb; // Accès à l'objet global $wpdb pour interagir avec la base de données WordPress
    $table_name = $wpdb->prefix . 'quote_numbers'; // Définition du nom de la table avec le préfixe WordPress

    // Vérifie si la table existe déjà
    if ($wpdb->get_var("SHOW TABLES LIKE '{$table_name}'") != $table_name) {
        $charset_collate = $wpdb->get_charset_collate(); // Récupère le collate de la base de données (pour gérer le charset)

        // SQL pour créer la table si elle n'existe pas
        $sql = "CREATE TABLE $table_name (
            id INT NOT NULL AUTO_INCREMENT,       -- Clé primaire auto-incrémentée
            `year_month` VARCHAR(6) NOT NULL,      -- Colonne pour stocker l'année et le mois (ex : '2412' pour décembre 2024)
            `index_number` INT NOT NULL,           -- Colonne pour stocker l'index incrémenté pour ce mois
            PRIMARY KEY (id),                    -- Déclare 'id' comme clé primaire
            UNIQUE KEY unique_year_month (`year_month`) -- Déclare une contrainte unique sur 'year_month' pour éviter les doublons
        ) $charset_collate;"; // Ajout du charset et du collate pour la compatibilité de la table avec la base de données WordPress

        // Inclut le fichier pour utiliser dbDelta, qui gère la création et la mise à jour des tables
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql); // Crée la table ou met à jour sa structure si nécessaire
    }
}


function generate_quote_number() {
    global $wpdb; // Accès à l'objet global $wpdb pour interagir avec la base de données WordPress
    $table_name = $wpdb->prefix . 'quote_numbers'; // Nom de la table des numéros de devis

    // Récupère l'année et le mois actuels sous le format YYMM (ex. : 2412 pour décembre 2024)
    $current_year_month = date('ym');

    // Tente de récupérer l'index actuel pour l'année et le mois donnés
    $current_index = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT `index_number` FROM $table_name WHERE `year_month` = %s LIMIT 1",
            $current_year_month
        )
    );

    if ($current_index === null) {
        // Si aucun index n'existe pour ce mois, initialise l'index à 1
        $current_index = 1;

        // Insère une nouvelle entrée dans la table pour ce mois
        $wpdb->insert(
            $table_name,
            [
                'year_month'   => $current_year_month,
                'index_number' => $current_index,
            ],
            [
                '%s', // Type de donnée pour `year_month` : chaîne de caractères
                '%d', // Type de donnée pour `index_number` : entier
            ]
        );
    } else {
        // Si un index existe, incrémente l'index pour ce mois
        $current_index++;

        // Met à jour l'index dans la table
        $wpdb->update(
            $table_name,
            [
                'index_number' => $current_index,
            ],
            [
                'year_month' => $current_year_month, // Condition de la mise à jour
            ],
            [
                '%d', // Type de donnée pour `index_number` : entier
            ],
            [
                '%s', // Type de donnée pour `year_month` : chaîne de caractères
            ]
        );
    }

    // Génère le numéro de devis final sous le format YYMM-#### (ex. : 2412-0001)
    $quote_number = sprintf('%s%04d', $current_year_month, $current_index);

    return $quote_number;
}