<?php
// Ajouter un nouvel onglet dans le compte WooCommerce
function add_custom_account_tab($menu_links){
    $current_user = wp_get_current_user();

    // Si le compte a un plan Carte membre de l'année en cours et le role Membre parent
    if(has_premium_plan($current_user->ID) && in_array( 'member_role', $current_user->roles )){
        $menu_links = array_slice($menu_links, 0, 5, true)
            + array('manage-my-members' => 'Gérer les membres de mon groupe')
            + array_slice($menu_links, 5, NULL, true);
    }

    return $menu_links; 
}
add_filter('woocommerce_account_menu_items', 'add_custom_account_tab');


// Créer l'endpoint pour l'onglet personnalisé
add_action('init', 'my_init_hook');
function my_init_hook(){
    add_rewrite_endpoint('manage-my-members', EP_PAGES);
}


// Contenu de l'onglet pour ajouter des sous-comptes
add_action('woocommerce_account_manage-my-members_endpoint', 'custom_account_tab_content');
function custom_account_tab_content(){
    // Vérifie que l'utilisateur a la carte membre et qu'il a le rôle Membre
    $current_user = wp_get_current_user();
    if(!has_premium_plan($current_user->ID) || !in_array( 'member_role', $current_user->roles )) return;

    $sub_tabs = array(
        'manage-subaccounts' => 'Gérer les sous-comptes'
    );

    if(has_active_premium_plan()){
        $sub_tabs = array_merge(array('add-subaccount' => 'Ajouter un sous-compte'), $sub_tabs);
    }

    // Affiche le nombre de sous-comptes disponibles
    display_empty_child_account_in_my_account();

    // Créé les tabs avec les liens vers la page Ajouter un sous-compte ou manage les sous-comptes
    echo '<ul class="sub-navigation">';
    foreach ($sub_tabs as $key => $label) {
        $current_tab = isset($_GET['sub-tab']) ? $_GET['sub-tab'] : '';
        $active_class = $current_tab == $key ? 'is-active' : '';
        echo '<li class="tab ' . $active_class . '"><a href="' . esc_url(add_query_arg('sub-tab', $key, wc_get_account_endpoint_url('manage-my-members'))) . '">' . $label . '</a></li>';
    }
    echo '</ul>';

    
    // Affiche le contenu en fonction de la sous-navigation
    if(isset($_GET) && !empty($_GET)) {
        $current_tab = isset($_GET['sub-tab']) ? $_GET['sub-tab'] : 'add-subaccount';
        
        // Affiche un message lorsque les champs des sous-comptes ont bien été modifiés 
        if (isset($_GET['update_status']) && $_GET['update_status'] === 'success') {
            echo '<div class="woocommerce-notices-wrapper"><div class="woocommerce-message" role="alert">Les modifications ont été enregistrées avec succès.</div></div>';
        }
    
        if ($current_tab == 'add-subaccount') {
            // Formulaire pour ajouter des sous-comptes
            add_subaccount_form();
        } elseif ($current_tab == 'manage-subaccounts') {
            // Section pour gérer les sous-comptes
            manage_subaccounts();
        } elseif ($current_tab == 'edit-subaccount') {
            // Sauvegarde les modifications des sous-comptes
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_subaccount') {
                update_sub_account($_POST);
            }
            // Affiche les champs d'un sous-compte pour modification
            if (isset($_GET['action']) && ($_GET['action'] == 'edit_subaccount') && isset($_GET['subaccount_id'])) {
                edit_subaccount_page($_GET);
            }
        }
    }
}


function add_subaccount_form(){
    // Si le plugin Memberships est installé et que l'utilisateur a un plan Carte Membre on lui permet de commander des sous-compte
    if (function_exists('wc_memberships_get_membership_plans')) :
        $current_user = wp_get_current_user();
        if(!has_premium_plan($current_user->ID) || !in_array( 'member_role', $current_user->roles )) return;
        
        // Récupère le produit lié au plan Carte Membre
        $product = get_premium_plan_product();

        if(!empty($product)):
            // Récupère l'id de la variation Tarif préférentiel
            $variation_id = get_variation_by_attribute_value($product, 'attribute_pa_tarif-preferentiel', 'sous-compte');
    ?>
            <form method="post" id="subaccount_form">
                <div id="subaccount_fields">
                    <h3>Ajouter des sous-comptes</h3>

                    <div class="subaccount_set">
                        <p class="form-row form-row-first validate-required" id="subaccount_1_email_field" data-priority="10">
                            <label for="subaccount_1_email">Email&nbsp;<abbr class="required" title="obligatoire">*</abbr></label>
                            <span class="woocommerce-input-wrapper">
                                <input type="email" class="input-email" name="subaccount_1_email" id="subaccount_1_email" placeholder="" value="" aria-required="true" autocomplete="given-name">
                            </span>
                        </p>

                        <?php
                        // Récupérer les champs d'expédition de WooCommerce
                        $fields = WC()->checkout()->get_checkout_fields('shipping');

                        foreach ($fields as $key => $field) {
                            // Ajouter un préfixe unique pour chaque sous-compte
                            $subaccount_key = 'subaccount_1_' . $key;
                            woocommerce_form_field($subaccount_key, $field, '');
                        }
                        ?>
                    </div>
                </div>

                <input type="hidden" name="product_id" value="<?= esc_attr($variation_id); ?>">

                <?php 
                // Affiche le nombre de sous-comptes disponibles
                display_empty_child_account_in_my_account(); 
                ?>
                <div class="buttons-wrapper">
                    <button type="button" id="add_subaccount_button" class="button primary medium">Ajouter un autre sous-compte</button>
    
                    <?php if(!empty(get_empty_child_account())){
                        $button_text = 'Utiliser un abonnement libre pour ce sous-compte';
                    }else{
                        $button_text = 'Ajouter un abonnement pour ce sous-compte';
                    } ?>
                    <button type="submit" name="add_product_to_cart" class="button"><?= $button_text; ?></button>
                </div>
            </form>

            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    let subaccountCount = 1;

                    $('#add_subaccount_button').click(function(e) {
                        e.preventDefault();

                        // Faire une requête Ajax pour récupérer les champs d'expédition
                        subaccountCount++;

                        $.ajax({
                            url: woocommerce_params.ajax_url, // L'URL Ajax de WooCommerce
                            method: 'POST',
                            data: {
                                action: 'get_shipping_fields',
                                subaccount_index: subaccountCount,
                            },
                            success: function(response) {
                                if (response.success) {
                                    // Ajouter les nouveaux champs d'expédition dans le formulaire
                                    let subaccountHtml = `
                                        <div class="subaccount_set">
                                            <p class="form-row form-row-first validate-required" id="subaccount_${subaccountCount}_email_field" data-priority="10">
                                                <label for="subaccount_${subaccountCount}_email" class="">Email&nbsp;<abbr class="required" title="obligatoire">*</abbr></label>
                                                <span class="woocommerce-input-wrapper">
                                                    <input type="email" class="input-email" name="subaccount_${subaccountCount}_email" id="subaccount_${subaccountCount}_email" placeholder="" value="" aria-required="true" autocomplete="given-name">
                                                </span>
                                            </p>
                                            ${response.data}
                                            <button type="button" class="remove_subaccount_button button primary small">Supprimer ce sous-compte</button>
                                        </div>
                                    `;
                                    $('#subaccount_fields').append(subaccountHtml);
                                }
                            }
                        });
                    });

                    // Supprimer un sous-compte
                    $(document).on('click', '.remove_subaccount_button', function(e) {
                        e.preventDefault();
                        $(this).parent('.subaccount_set').remove();
                    });
                });
            </script>
    <?php endif;
    endif;
}


// Tableau contenant la liste des sous-comptes
function manage_subaccounts(){
    // Vérifie que l'utilisateur a la carte membre et qu'il a le rôle Membre
    $current_user = wp_get_current_user();
    if(!has_premium_plan($current_user->ID) || !in_array( 'member_role', $current_user->roles )){
         return;
    }

    $current_premium_plan = get_current_premium_plan();

    echo '<h3>Gérer vos sous-comptes</h3>';

    // Récupérer tous les sous-comptes liés à l'utilisateur actuel
    $subaccounts = get_users(array(
        'meta_key' => 'parent_user_id',
        'meta_value' => get_current_user_id()
    ));

    if(!empty($subaccounts)){
        echo '<table class="shop_table membership_plans">
            <thead>
                <tr>
                    <th>Identifiant</th>
                    <th>Email</th>
                    <th>Date d\'ajout</th>
                    <th>Abonnement</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>';
                foreach ($subaccounts as $subaccount){
                    $added_date = get_user_meta($subaccount->ID, 'subaccount_added_date', true);
                    echo '<tr>';
                        echo '<td>' . $subaccount->user_login . '</td>';
                        echo '<td>' . $subaccount->user_email . '</td>';
                        echo '<td>' . esc_html($added_date ? date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($added_date)) : __('Non disponible', 'ocim')) . '</td>';
                        echo '<td>';
                            // Si le subaccount a la Carte membre
                            if (has_premium_plan($subaccount->ID)){
                                $user_active_plans = wc_memberships_get_user_active_memberships($subaccount->ID);
                                
                                foreach($user_active_plans as $member){
                                    // Plan lié à ce Member
                                    $plan = $member->get_plan();
                                    
                                    if($current_premium_plan->get_id() == $plan->get_id()){
                                        echo '<a href="' . esc_url( add_query_arg(array(
                                            'action' => 'remove_membership', 
                                            'subaccount_id' => $subaccount->ID,
                                            'membership_id' => $member->get_id()
                                            ), wc_get_account_endpoint_url('manage-my-members')) ) . '">
                                            Supprimer "' . $current_premium_plan->get_name() . '"
                                        </a>';
                                    }
                                }
                            }else{
                                echo 'Pas de ' . $current_premium_plan->get_name();
                            }
                        echo '</td>';
                        echo '<td>';
                            echo '<a href="' . esc_url( add_query_arg( array(
                                'sub-tab' => 'edit-subaccount',
                                'action' => 'edit_subaccount', 
                                'subaccount_id' => $subaccount->ID
                                ), wc_get_account_endpoint_url('manage-my-members') ) ) . '">
                                Modifier le compte
                            </a>
                        </td>
                    </tr>';
                }
            echo '</tbody>';
        echo '</table>';
    }else{
        echo '<p>Vous n\'avez pas de sous-comptes pour l\'instant.</p>';
    }
}


// Supprimer un sous-compte du plan Carte membre
add_action('template_redirect', 'handle_template_redirect');
function handle_template_redirect() {
    // Si on a cliqué sur Supprimer (l'abonnement du sous-compte)
    if (isset($_GET['action']) && $_GET['action'] === 'remove_membership' && isset($_GET['subaccount_id']) && isset($_GET['membership_id'])) {
        $subaccount_id = intval($_GET['subaccount_id']);
        $membership_id = intval($_GET['membership_id']);

        $parent_user_id = get_user_meta($subaccount_id, 'parent_user_id', true);
        
        // Vérifie si l'utilisateur actuel est le parent du sous-compte
        if ($parent_user_id == get_current_user_id()) {
            // Récupère le Member de memberships
            $membership = wc_memberships_get_user_membership($membership_id);

            // Récupère le plan lié à ce Member
            $plan = $membership->get_plan();
            $plan_name = $plan->get_name();

            if ($membership && $membership->get_user_id() == $subaccount_id) {
                $membership->cancel_membership(); // Annule l'adhésion
                wc_add_notice($plan_name . ' a été supprimé avec succès.', 'success');
                
                // Met à jour le nombre de sous-compte disponible
                if(metadata_exists('user', get_current_user_id(), 'empty_child_account')){
                    $current_empty_child_account = get_empty_child_account();
                    $current_empty_child_account++;
                    set_empty_child_account($current_empty_child_account);
                }

                // On supprime la meta parent_user_id du sous-compte
                delete_user_meta($subaccount_id, 'parent_user_id');

                // Récupère l'objet user
                $subaccount = get_user_by('ID', $subaccount_id);
                
                // On lui supprime le role child_member_role
                if(in_array('child_member_role', $subaccount->roles)){
                    $subaccount->remove_role('child_member_role');
                }
                
                // S'il n'a pas d'autres roles, on lui assigne le rôle Abonné
                if(empty($subaccount->roles)){
                    $subaccount->set_role('subscriber');
                }

            } else {
                $notice = 'Impossible de trouver ' . $plan_name;
                wc_add_notice($notice, 'error');
            }
        } else {
            wc_add_notice('Vous n\'avez pas la permission de supprimer ce plan', 'error');
        }

        // Rediriger vers la page des sous-comptes
        wp_safe_redirect(esc_url(add_query_arg('sub-tab', 'manage-subaccounts', wc_get_account_endpoint_url('manage-my-members'))));
        exit;
    }

    // Lorsqu'on soumet les sous-comptes, on ajoute des produits au panier avec les infos des sous-comptes et redirige vers le panier
    if (isset($_POST['add_product_to_cart']) && is_user_logged_in()) {
        $product_id = intval($_POST['product_id']);

        $keys = array('email', 'first_name', 'last_name', 'company', 'country', 'address_1', 'address_2', 'postcode', 'city', 'phone');
        $array_data = array();

        // Récupère dans un tableau pour chaque $keys les valeurs correspondantes
        foreach ($keys as $key) {
            $matching_values = array_filter($_POST, function($data_key) use ($key) {
                return strpos($data_key, $key) !== false;
            }, ARRAY_FILTER_USE_KEY);
            
            // Ajoute les valeurs au tableau des résultats sous la clé actuelle
            if($key == 'postcode') {
                // garde uniquement les chiffres dans le code postal
                $array_data[$key] = array_values(array_map(function($postal_code) {
                    return preg_replace( '/[^0-9]/', '', $postal_code);
                }, $matching_values));
            }else{
                $array_data[$key] = array_values($matching_values);
            }
        }
        
        
        // Sanitize and prepare the arrays
        $emails      = isset($array_data['email']) ? array_map('sanitize_email', $array_data['email']) : [];
        $first_names = isset($array_data['first_name']) ? array_map('sanitize_text_field', $array_data['first_name']) : [];
        $last_names  = isset($array_data['last_name']) ? array_map('sanitize_text_field', $array_data['last_name']) : [];
        $companies   = isset($array_data['company']) ? array_map('sanitize_text_field', $array_data['company']) : [];
        $countries   = isset($array_data['country']) ? array_map('sanitize_text_field', $array_data['country']) : [];
        $address_1   = isset($array_data['address_1']) ? array_map('sanitize_text_field', $array_data['address_1']) : [];
        $address_2   = isset($array_data['address_2']) ? array_map('sanitize_text_field', $array_data['address_2']) : [];
        $postcodes   = isset($array_data['postcode']) ? array_map('sanitize_text_field', $array_data['postcode']) : [];
        $cities      = isset($array_data['city']) ? array_map('sanitize_text_field', $array_data['city']) : [];
        $phones      = isset($array_data['phone']) ? array_map('sanitize_text_field', $array_data['phone']) : [];
        //$states      = isset($array_data['state']) ? array_map('sanitize_text_field', $array_data['state']) : [];


        // Validation des champs requis
        $errors = [];
        foreach ($emails as $index => $email) {
            if (email_exists($email)) {
                $errors[] = 'Un compte avec cette adresse mail existe déjà';
            }
            if (empty($email) || !is_email($email)) {
                $errors[] = 'L\'adresse e-mail est requise et doit être valide.';
            }
            if (empty($first_names[$index])) {
                $errors[] = 'Le prénom est requis.';
            }
            if (empty($last_names[$index])) {
                $errors[] = 'Le nom de famille est requis.';
            }
            if (empty($address_1[$index])) {
                $errors[] = 'L\'adresse est requise.';
            }
            if (empty($cities[$index])) {
                $errors[] = 'La ville est requise.';
            }
            if (empty($postcodes[$index])) {
                $errors[] = 'Le code postal est requis.';
            }
        }

        // Si des erreurs sont détectées, ajoutez-les en tant que messages d'erreur et ne redirigez pas
        if (!empty($errors)) {
            foreach ($errors as $error) {
                wc_add_notice($error, 'error');
            }
            return; // Empêche la redirection vers le panier
        }

        // Ajouter chaque sous-compte comme un item distinct        
        $empty_child_account = get_empty_child_account();

        foreach ($emails as $index => $email) {
            $item_account_data['subaccount_data'] = array(
                'email'      => $email,
                'first_name' => $first_names[$index],
                'last_name'  => $last_names[$index],
                'company'    => $companies[$index],
                'country'    => $countries[$index],
                'address_1'  => $address_1[$index],
                'address_2'  => $address_2[$index],
                'postcode'   => $postcodes[$index],
                'city'       => $cities[$index],
                'phone'      => $phones[$index],
                //'state'      => $states[$index],
            );

            /* S'il reste des sous-comptes disponibles, on ajoute la meta empty_child_account à true
             * Pour que le produit dans le panier soit à 0€
             */
            if(!empty($empty_child_account)){
                $item_account_data['subaccount_data']['empty_child_account'] = true;
            }
            
            $empty_child_account--;

            $item_account_data['unique_key'] = md5(microtime() . rand());

            $quantity = 1; // Ajouter une seule unité par sous-compte

            // Ajoute au panier le produit + les informations de compte
            WC()->cart->add_to_cart($product_id, $quantity, 0, array(), $item_account_data);
        }

        // Rediriger vers le panier
        wp_redirect(wc_get_cart_url());
        exit;
    }
}


// Modifier un sous-compte
function edit_subaccount_page($get_vars) {
    if (!is_account_page() || !isset($get_vars['subaccount_id'])) {
        return;
    }

    $subaccount_id = intval($get_vars['subaccount_id']);
    $current_user_id = get_current_user_id();
    $parent_user_id = get_user_meta($subaccount_id, 'parent_user_id', true);

    if(!empty($parent_user_id) && is_array($parent_user_id)){
        $parent_user_id = reset($parent_user_id);
    }

    // Vérifiez que l'utilisateur actuel est bien le parent du sous-compte
    if (intval($parent_user_id) !== $current_user_id) {
        return '<p>Vous n\'avez pas la permission de modifier ce compte.</p>';
    }

    $subaccount_user = get_user_by('ID', $subaccount_id);
    if (!$subaccount_user) {
        return '<p>Ce sous-compte n\'existe pas.</p>';
    }

    $form = generate_dynamic_subaccount_form($subaccount_id);

    echo $form . '<a href="' . esc_url(add_query_arg('sub-tab', 'manage-subaccounts', wc_get_account_endpoint_url('manage-my-members'))) . '">Retour à la gestion des sous-comptes</a>';
}


// Pour la modification du sous-compte, récupère tous ses champs
function generate_dynamic_subaccount_form($subaccount_id) {

    // Obtenir les champs personnalisés pour le compte si nécessaire
    $account_fields = array(
        'first_name' => array(
            'label' => __('Prénom', 'ocim'),
            'type'  => 'text',
        ),
        'last_name' => array(
            'label' => __('Nom', 'ocim'),
            'type'  => 'text',
        ),
        'email' => array(
            'label' => __('Email', 'ocim'),
            'type'  => 'email',
        ),
    );

    // Obtenir les champs WooCommerce pour la facturation
    //$shipping_fields = WC()->countries->get_address_fields('', 'shipping');
    $shipping_fields = WC()->checkout()->get_checkout_fields('shipping');

    // Créer un formulaire basé sur les champs récupérés
    ob_start();
    
    echo '<form method="post">
        <h3>Modifier les informations du compte</h3>';

        foreach ($account_fields as $key => $field): 
            $value = get_user_meta($subaccount_id, $key, true) ?: ( $key === 'email' ? get_userdata($subaccount_id)->user_email : '' );
            echo '<p>
                <label for="' . esc_attr($key) . '">' . esc_html($field['label']). ' :</label>
                <input type="' . esc_attr($field['type']) . '" name="' . esc_attr($key) . '" id="' . esc_attr($key) . '" value="' . esc_attr($value) . '"' . ($field['type'] === 'email' ? 'required' : '') .'>
            </p>';
        endforeach;

        echo '<h3>Modifier les informations de livraison</h3>';

        foreach ($shipping_fields as $key => $field):
            $value = get_user_meta($subaccount_id, $key, true);
            echo '<p>
                <label for="'. esc_attr($key) . '">' . esc_html($field['label']) . ' :</label>
                <input type="text" name="' . esc_attr($key) . '" id="' . esc_attr($key) . '" value="' . esc_attr($value) . '" placeholder="' . esc_attr($field['placeholder'] ?? '') . '" ' . (!empty($field['required']) ? 'required' : '') . '>
            </p>';
        endforeach;

        echo '<input type="hidden" name="subaccount_id" value="' . esc_attr($subaccount_id) . '">
        <input type="hidden" name="action" value="update_subaccount">
        <div class="button-wrapper">
            <button type="submit" class="button">Mettre à jour</button>
        </div>
    </form>';

    return ob_get_clean();
}


// Mise à jour des infos du sous-compte modifié
function update_sub_account($post_vars){
    $subaccount_id = intval($post_vars['subaccount_id']);
    $current_user_id = get_current_user_id();
    $parent_user_id = intval(get_user_meta($subaccount_id, 'parent_user_id', true));

    // Vérifiez que l'utilisateur actuel est bien le parent du sous-compte
    if ($parent_user_id !== $current_user_id) {
        wp_die('Vous n\'avez pas la permission de modifier ce compte.');
    }

    // Mettre à jour les informations du compte
    $account_fields = array('first_name', 'last_name', 'email');
    foreach ($account_fields as $field) {
        if (isset($_POST[$field])) {
            if ($field === 'email') {
                wp_update_user(array(
                    'ID'         => $subaccount_id,
                    'user_email' => sanitize_email($_POST[$field]),
                ));
            } else {
                update_user_meta($subaccount_id, $field, sanitize_text_field($_POST[$field]));
            }
        }
    }

    // Mettre à jour les informations de facturation
    $shipping_fields = WC()->checkout()->get_checkout_fields('shipping');

    foreach ($shipping_fields as $key => $field) {
        if (isset($_POST[$key])) {
            update_user_meta($subaccount_id, $key, sanitize_text_field($_POST[$key]));
        }
    }

    // Redirection après mise à jour
    wp_redirect(add_query_arg(array(
        'update_status' => 'success',
        'sub-tab' => 'manage-subaccounts'
    ), wc_get_account_endpoint_url('manage-my-members')));
    exit;
}


// Traduit correctement le label du champ Téléphone des champs d'expédition (le label restait en Phone)
add_filter('woocommerce_checkout_fields', 'customize_shipping_phone_label');
function customize_shipping_phone_label($fields) {
    if (isset($fields['billing']['billing_company'])) {
        $fields['billing']['billing_company']['label'] = __('Organisme', 'ocim');
    }
    if (isset($fields['shipping']['shipping_company'])) {
        $fields['shipping']['shipping_company']['label'] = __('Organisme', 'ocim');
    }
    if (isset($fields['shipping']['shipping_phone'])) {
        $fields['shipping']['shipping_phone']['label'] = __('Téléphone', 'ocim');
    }
    return $fields;
}


// Fonction PHP pour récupérer en ajax les champs d'expédition de Woocommerce et les afficher dans 
// l'onglet "Ajouter des membres" et saisir les coordonnées des sous-comptes
add_action('wp_ajax_get_shipping_fields', 'get_shipping_fields_ajax');
add_action('wp_ajax_nopriv_get_shipping_fields', 'get_shipping_fields_ajax');
function get_shipping_fields_ajax(){
    if (isset($_POST['subaccount_index'])) {
        $index = intval($_POST['subaccount_index']);

        // Récupérer les champs d'expédition de WooCommerce
        $fields = WC()->checkout()->get_checkout_fields('shipping');

        ob_start();

        // Boucler à travers les champs d'expédition et les afficher
        foreach ($fields as $key => $field) {
            // Ajouter un préfixe unique pour chaque sous-compte
            $subaccount_key = 'subaccount_' . $index . '_' . $key;
            woocommerce_form_field($subaccount_key, $field, '');
        }

        $output = ob_get_clean();
        wp_send_json_success($output);
    }

    wp_die();
}


// Ajoute des champs dans l'édition de l'adresse de facturation du compte
add_filter( 'woocommerce_billing_fields', 'add_custom_billing_fields_to_account', 10, 1 );
function add_custom_billing_fields_to_account( $fields ) {
    $fields['billing_siret'] = array(
        'type'        => 'text',
        'label'       => __( 'SIRET', 'ocim' ),
        'required'    => false,
        'class'       => array('form-row-wide'),
        'clear'       => true,
    );
    $fields['billing_taxe_intra'] = array(
        'type'        => 'text',
        'label'       => __( 'Numéro de TVA intracommunautaire', 'ocim' ),
        'required'    => false,
        'class'       => array('form-row-wide'),
        'clear'       => true,
    );

    return $fields;
}


// Sauvegarde les champs dans l'édition de l'adresse de facturation du compte lors d'une modif
add_action( 'woocommerce_customer_save_address', 'save_custom_billing_fields_from_account', 10, 2 );
function save_custom_billing_fields_from_account( $customer_id, $address_type ) {
    if ( $address_type === 'billing' ) {
        if ( isset($_POST['billing_siret']) ) {
            update_user_meta( $customer_id, 'billing_siret', sanitize_text_field( $_POST['billing_siret'] ) );
        }
        if ( isset($_POST['billing_taxe_intra']) ) {
            update_user_meta( $customer_id, 'billing_taxe_intra', sanitize_text_field( $_POST['billing_taxe_intra'] ) );
        }
    }
}


// A la sauvegarde, création d'un user membership, on ajoute une meta avec l'id du user membership dans le compte
add_action('wc_memberships_user_membership_saved', 'user_membership_saved', 20, 2);
function user_membership_saved($plan, $params) {
    $user_id = $params['user_id'];
    $user_membership_id = $params['user_membership_id'];

    $meta_key = 'ocim_user_memberships';

    if ( metadata_exists( 'user', $user_id, $meta_key ) ) {
        $user_meta = get_user_meta($user_id, $meta_key, true);

        $user_meta[] = $user_membership_id;

        $user_meta = array_unique($user_meta);

        update_user_meta( $user_id, $meta_key, $user_meta );
    }else{
        add_user_meta($user_id, $meta_key, [$user_membership_id]);
    }
}


// Pour Catapulpe
add_action('rest_api_init', function () {
    register_rest_field(
        'user', // Le type de ressource REST où ajouter ce champ (ici 'user')
        'ocim_user_memberships', // Le nom du champ dans l'API REST
        array(
            'get_callback'    => 'get_ocim_user_memberships', // Fonction pour récupérer la valeur
            'update_callback' => null, // Vous pouvez ajouter une fonction pour la mise à jour si nécessaire
            'schema'          => array(
                'description' => 'Liste des adhésions de l\'utilisateur',
                'type'        => 'array',
                'items'       => array(
                    'type' => 'integer',
                ),
                'context'     => array('view'), // Disponible en lecture et en édition
            ),
        )
    );

    register_rest_field( 
        'wc_membership_plan', 
        'ocim_accessible_content_ids', 
        array(
            'get_callback' => function ( $object ) {
                // Récupérer la méta depuis l'objet
                $meta = get_post_meta( $object['id'], 'ocim_accessible_content_ids', true );

                // Désérialiser si nécessaire et retourner un tableau JSON
                return maybe_unserialize( $meta );
            },
            'update_callback' => function ( $value, $object ) {
                // Valider que la valeur est un tableau et mettre à jour la méta
                if ( is_array( $value ) ) {
                    update_post_meta( $object->ID, 'ocim_accessible_content_ids', $value );
                }
            },
            'schema' => [
                'description' => 'Accessible content IDs for the membership plan',
                'type'        => 'array',
                'items'       => array(
                    'type' => 'integer',
                ),
                'context'     => array('view'),
            ],
        )
    );
});

// Fonction pour retourner la méta depuis l'API
function get_ocim_user_memberships($user, $field_name, $request) {
    $meta_value = get_user_meta($user['id'], 'ocim_user_memberships', true);
    return is_array($meta_value) ? $meta_value : array();
}
