<?php
// Ajoute une class active-plan sur les produits liés aux plans actifs de l'utilisateur
add_filter('woocommerce_post_class', 'add_bought_product_class', 10, 2);
function add_bought_product_class($classes, $product) {
    if (!is_user_logged_in()) {
        return $classes;
    }

    // Récupérer les produits achetés par l'utilisateur connecté
    $customer_id = get_current_user_id();
    $user_active_plans = wc_memberships_get_user_memberships($customer_id, array('status' => array('active', 'delayed')));
    $linked_products = array();

    
    foreach($user_active_plans as $member){
        // Plan lié à ce Member
        $plan = $member->get_plan();
        $plan_products = $plan->get_products();

        if (!empty($plan_products)) {
            foreach ($plan_products as $plan_product) {
                $linked_products[] = $plan_product->get_id();
            }
        }
    }

    // Vérifier si le produit courant a été acheté
    if (in_array($product->get_id(), $linked_products)) {
        $classes[] = 'active-plan';
    }

    return $classes;
}


// Réordonne les hooks avant la loop de produits pour afficher les filtres, tris, nombre de résultats
add_action('init', 'reordonner_woocommerce_before_shop_loop_actions');
function reordonner_woocommerce_before_shop_loop_actions() {
    // Supprimer les actions par défaut
    remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
    remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
    remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

    // Ajouter les actions dans le nouvel ordre
    add_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
    add_action('woocommerce_before_shop_loop', 'add_product_category_filter', 15);
    add_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 20);
    add_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 25);
}


// Customise le filtre par catégories
function add_product_category_filter() {

    // Obtenir les catégories de produits
    $categories = get_terms([
        'taxonomy' => 'product_cat',
        'hide_empty' => true,
    ]);

    if (!empty($categories)) {
        echo '<form class="filter-form" method="GET" action="' . esc_url(get_permalink(wc_get_page_id('shop'))) . '">';
        echo '<select id="categories-filter" name="categories-filter" onchange="this.form.submit()">';
        echo '<option value="">' . __('Toutes les catégories', 'text-domain') . '</option>';

        foreach ($categories as $category) {
            if($category->slug != 'non-classe'){
                $selected = (isset($_GET['categories-filter']) && $_GET['categories-filter'] === $category->slug) ? 'selected' : '';
                echo '<option value="' . esc_attr($category->slug) . '" ' . $selected . '>';
                echo esc_html($category->name);
                echo '</option>';
            }
        }

        echo '</select>';

        echo '<ul>'; 
        foreach ($categories as $category) {
            if($category->slug != 'non-classe'){
                $selected = (isset($_GET['categories-filter']) && $_GET['categories-filter'] === $category->slug) ? '' : 'hollow';
                echo '<li>';
                echo '<a href="?categories-filter=' . esc_attr($category->slug) . '" class="button primary small ' . $selected . '">' . esc_html($category->name) . '</a>';
                echo '</li>';
            }
        }
        echo '</ul>';
        echo '</form>';
    }
}


add_action('pre_get_posts', 'filtrer_produits_par_categorie');
function filtrer_produits_par_categorie($query) {
    // Vérifier qu'il s'agit de la page boutique ou d'une archive de produits
    if (is_admin() || !$query->is_main_query() || !is_post_type_archive('product')) {
        return;
    }

    // Appliquer le filtre si une catégorie est sélectionnée
    if (!empty($_GET['categories-filter'])) {
        $query->set('tax_query', [
            [
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => sanitize_text_field($_GET['categories-filter']),
            ],
        ]);
    }

    // Si on filtre la catégorie Lettre de l'Ocim, il faut ordonner par numéro (champ ACF)
    if (!empty($_GET['categories-filter']) && ($_GET['categories-filter'] == 'la-lettre-de-locim')) {
        $query->set('meta_key', 'issue');
        $query->set('orderby','meta_value_num');
        $query->set('order','DESC');
    }
}

// Supprime du tri, le tri par prix
add_filter('woocommerce_catalog_orderby', function ($options) {
    unset($options['price']); // Supprime "Tri par prix : du moins cher au plus cher"
    unset($options['price-desc']); // Supprime "Tri par prix : du plus cher au moins cher"

    return $options;
});