<?php
// Change le label à côté du select de tarif
add_action( 'woocommerce_attribute_label', 'wc_ninja_change_attribute_label', 20, 3 );
function wc_ninja_change_attribute_label( $label, $name, $product ) {
	// Check if on single product page and if the attribute  name is 'color'
	if ( is_product() && 'pa_tarif-preferentiel' === $name ) {
		global $product;

		$label = 'Choisir un tarif';
	}

	// Return the label, untouched if none of the above conditions were true
	return $label;
}


// En front, on supprime l'option Sous compte du sélecteur de variation dans le single-product
add_filter('woocommerce_available_variation', 'remove_variation_option');
function remove_variation_option($variations) {
    if ( is_product() ) {
        $attribute_to_remove = 'attribute_pa_tarif-preferentiel';
        $value_to_remove = 'sous-compte';
        
        // Vérifiez si la variation contient l'attribut à supprimer
        if (isset($variations['attributes'][$attribute_to_remove]) && $variations['attributes'][$attribute_to_remove] === $value_to_remove) {
            // Supprimez l'option de variation
            unset($variations['attributes'][$attribute_to_remove]);
        }
    }

    return $variations;
}


// Supprime les catégories (sous le bouton Ajouter au panier)
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );


// Supprime le bloc price dans les produits simple
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );


// Affiche le prix HT et TTC dans le single product
add_action( 'woocommerce_single_product_summary', 'display_price_with_and_without_tax', 15 );
function display_price_with_and_without_tax() {
    global $product;

    // Pour les produits variables, on affiche des div vides pour les prix et les mets à jour en js suivant la sélection de variation
    if ( $product->is_type( 'variable' ) ) {
        echo '<div id="price-without-tax"></div>';
        echo '<div id="price-with-tax"></div>';
    } else {
        if ( $product->is_taxable() ) {            
            // Récupération du prix brut (TTC)
            $price_ttc = wc_get_price_to_display( $product );

            // Récupération de la TVA
            $tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
            if(!empty( $tax_rates )){
                $tax_rates = reset ( $tax_rates );
            }

            if(isset( $tax_rates['rate'] )){
                $tax_rate = $tax_rates['rate'];
            }

            $tax_percentage = isset( $tax_rate ) ? $tax_rate : 0;
            // Calcul du prix HT            
            $price_ht = $price_ttc / ( 1 + ($tax_percentage/100) );

            // Vérifie si la TVA doit être à 0
            $tva_to_zero = tva_to_zero();

            if($tva_to_zero){
                echo '<div id="price-with-tax">' . wc_price( $price_ttc ) . '</div>';
            }else{
                echo '<div id="price-without-tax">Prix HT : ' . wc_price( $price_ht ) . '</div>';
                echo '<div id="price-with-tax">' . wc_price( $price_ttc ) . ' Prix TTC</div>';
            }
        }
    }
}



add_action('woocommerce_single_product_summary', 'custom_replace_add_to_cart_button', 15);
function custom_replace_add_to_cart_button() {
    global $product;

    // Vérifie si le produit a le tag 'Sur devis'
    if (has_term('Sur devis', 'product_tag', $product->get_id())) {
        // Supprimer le bouton "Ajouter au panier"
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);

        // Ajouter un bouton personnalisé
        echo '<a href="#footer" class="button contact-button"><div class="bouton-cyan"></div>Nous contacter</a>';
    }
}


// Pour chaque variation d'un produit, on récupère sa taxe
add_filter( 'woocommerce_available_variation', 'add_tax_rate_to_variation', 10, 3 );
function add_tax_rate_to_variation( $variation_data, $product, $variation ) {
    if ( $variation->is_taxable() ) {
        // Utilise la fonction pour obtenir le taux de TVA de la variation
        $tax_rate = get_variation_tax_rate( $variation );
        
        // Vérifie et ajoute le taux à la donnée de variation
        if ( !empty($tax_rate) ) {
            $variation_data['tax_rate'] = $tax_rate;
        }
    } else {
        $variation_data['tax_rate'] = 0;
    }
    return $variation_data;
}


// Ajoute un js dans le footer pour gérer les prix et taxes en fonction de la variation sélectionnée
add_action( 'wp_footer', 'update_variation_prices_script' );
function update_variation_prices_script() {
    
    // Si on est dans le single product, on met à jour les prix et leur taxe suivant la sélection de variation
    if ( is_product() ) :
        $premium_plan_product = get_premium_plan_product();
        
        if ( empty( $premium_plan_product ) ) {
            return;
        }
        
        if(!empty($premium_plan_product)){
            // Récupère l'id de la variation "Plein tarif"
            $premium_default_variation_id = get_default_variation_id($premium_plan_product);
        }

        $product = wc_get_product(get_the_ID());

        if ( empty( $product ) || ! $product->is_visible() ) {
            return;
        }

        // Vérifie si la TVA doit être à 0
        $tva_to_zero = tva_to_zero();

        // Si on est dans le single product Carte membre, on ajoute/supprime l'input quantity suivant la variation sélectionnée
        if($product->get_id() == $premium_plan_product->get_id()):
    ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    <?php // Écoute les changements de variation ?>
                    $(document).on('show_variation', function(event, variation) {                                          
                        <?php // Vérifie si une variation est sélectionnée ?>
                        if (variation) {
                            <?php // L'id de la variation "Plein tarif" ?>
                            const premium_default_variation_id = <?= $premium_default_variation_id; ?>;

                            <?php // Si c'est la variation "plein tarif" qui est sélectionnée, on charge le sélecteur de quantité ?>
                            if (parseInt(variation.variation_id) === premium_default_variation_id) {
                                $.ajax({
                                    url: woocommerce_params.ajax_url,
                                    type: 'POST',
                                    data: {
                                        action: 'load_quantity_selector',
                                        variation_id: variation.variation_id
                                    },
                                    success: function(response) {                                    
                                        if (response.success) {
                                            <?php // Ajoute le sélecteur de quantité dans le formulaire ?>
                                            $('.quantity-wrapper').html(response.data);
                                        } else {
                                            <?php // Efface si erreur ?>
                                            $('.quantity-wrapper').empty();
                                        }
                                    }
                                });
                            } else {
                                <?php // Efface le sélecteur de quantité pour les autres variations ?>
                                $('.quantity-wrapper').empty();
                            }
                        }
                    });
                });
            </script>
        <?php endif; ?>
        
        <script type="text/javascript">
            jQuery(document).ready(function($) {
                <?php // Fonction pour mettre à jour les prix HT et TTC ?>
                const tvaToZero = <?= json_encode( $tva_to_zero ); ?>;

                function updatePrices(variation) {
                    if (variation) {
                        <?php // Prix HT de la variation ?>
                        var priceWithTax = variation.display_price;
                        
                        <?php // Vérifie si tax_rate est défini dans les données de variation ?>
                        var taxRate = variation.tax_rate ? parseFloat(variation.tax_rate) : 0;
                        var priceWithoutTax = priceWithTax * (1 - taxRate / 100);

                        if (tvaToZero) {
                            $('#price-with-tax').text(wc_price_format(priceWithTax));
                        }else{
                            $('#price-without-tax').text('Prix HT : ' + wc_price_format(priceWithoutTax));
                            $('#price-with-tax').text(wc_price_format(priceWithTax) + ' TTC');
                        }
                    }
                }

                <?php // Formatage de prix WooCommerce ?>
                function wc_price_format(price) {
                    return price.toFixed(2).replace('.', ',') + '€';
                }

                <?php // Écoute les changements de variation ?>
                $(document).on('show_variation', function(event, variation) {
                    <?php // Met à jour les prix HT et TTC ?>
                    updatePrices(variation);
                });
            });
        </script>
    <?php endif;
}


// Action AJAX pour retourner le champ de quantité uniquement pour la variation "Tarif préférentiel"
add_action('wp_ajax_load_quantity_selector', 'load_quantity_selector');
add_action('wp_ajax_nopriv_load_quantity_selector', 'load_quantity_selector');
function load_quantity_selector() {
    $premium_plan_product = get_premium_plan_product();    

    if(!empty($premium_plan_product)){
        $premium_default_variation_id = get_default_variation_id($premium_plan_product);
    }
    // Vérifie si l'ID de la variation correspond à la vriation plein-tarif
    if (isset($_POST['variation_id']) && $_POST['variation_id'] == $premium_default_variation_id) {
        ob_start();
        woocommerce_quantity_input(); // Génère le HTML du sélecteur de quantité
        $quantity_html = ob_get_clean();
        wp_send_json_success($quantity_html);
    } else {
        wp_send_json_error('Invalid variation');
    }
}


// Supprime les hooks par défaut des tabs et ventes croisées pour pouvoir modifier la structure html et appeler leur fonction directement dans le template
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );