<?php
// Afficher les données des sous-comptes sur la page Thank You et dans les e-mails
add_action('woocommerce_order_item_meta_end', 'display_subaccount_data_in_order', 10, 4);
function display_subaccount_data_in_order($item_id, $item, $order, $plain_text) {
    // Obtenir les données personnalisées de l'article de commande
    $subaccount_data = wc_get_order_item_meta($item_id, 'subaccount_data', true);

    // Si les données existent, les afficher
    if (!empty($subaccount_data)) {
        echo '<ul>';
        foreach ($subaccount_data as $key => $value) {
            if(!empty($key) && !empty($value)) {
                switch($key){
                    case 'email':
                        $label = 'Email';
                        break;
                    case 'first_name':
                        $label = 'Prénom';
                        break;
                    case 'last_name':
                        $label = 'Nom';
                        break;
                    case 'company':
                        $label = 'Entreprise';
                        break;
                    case 'address_1':
                        $label = 'Adresse';
                        break;
                    case 'address_2':
                        $label = 'Complément d\'adresse';
                        break;
                    case 'city':
                        $label = 'Ville';
                        break;
                    case 'postcode':
                        $label = 'Code postal';
                        break;
                    case 'phone':
                        $label = 'Téléphone';
                        break;
                    case 'country':
                        $label = 'Pays';
                        $countries = WC()->countries->get_countries();
                        $country_name = isset($countries[$value]) ? $countries[$value] : $value;
                        $value = $country_name;
                        break;
                }

                echo '<li>' . $label . ' : ' . esc_html($value) . '</li>';
            }
        }
        echo '</ul>';
    }


    // Récupère les données du formulaire pour la biennale
    $biennale_data = wc_get_order_item_meta($item_id, 'biennale_data', true);

    // Si les données existent, les afficher
    if (!empty($biennale_data)) {
        echo '<p></p>';
        echo '<p><strong>Informations sur la personne inscrite pour la biennale :</strong></p>';
        echo '<ul>';
        foreach ($biennale_data as $key => $value) {
            if(!empty($key) && !empty($value)) {
                switch($key){
                    case 'name':
                        $label = 'Nom';
                        break;
                    case 'first_name':
                        $label = 'Prénom';
                        break;
                    case 'institution':
                        $label = 'Institution';
                        break;
                    case 'job':
                        $label = 'Fonction';
                        break;
                    case 'email':
                        $label = 'Email';
                        break;
                    case 'motivation':
                        $label = 'Motivation';
                        break;
                }

                echo '<li>' . $label . ' : ' . esc_html($value) . '</li>';
            }
        }
        echo '</ul>';
    }
}



add_action('woocommerce_thankyou', 'create_subaccount_and_add_membership_after_order', 10, 1);
function create_subaccount_and_add_membership_after_order($order_id){
    if (!$order_id) return;

    $order = wc_get_order($order_id);

    // Récupére l'ID de l'utilisateur associé à la commande
    $parent_user_id = $order->get_user_id();
    $user = new WP_User($parent_user_id);
    
    // Si les champs n'ont pas été remplis pour les sous-compte, on met à jour la meta empty_child_account
    // Si empty_child_account > 0 dans le compte, l'utilisateur pourra ajouter des sous-compte sans devoir repayer
    $user_empty_account = (int) get_user_meta($parent_user_id, 'empty_child_account', true);
    
    // Récupère le produit Carte membre de l'année en cours
    $premium_product = get_premium_plan_product();

    
    if(!empty($premium_product)){
        $premium_product_id = $premium_product->get_id();

        // Récupère l'id de la variation sous-compte de l'attribut tarif préférentiel
        $discounted_variation_id = get_variation_by_attribute_value($premium_product, 'attribute_pa_tarif-preferentiel', 'sous-compte');
    }


    // Parcourt les articles de la commande pour récupérer les données des sous-comptes
    foreach ($order->get_items() as $item_id => $item) {
        $subaccount_data = $item->get_meta('subaccount_data');
        $order_product_id = $item->get_product_id();

        // S'il y a des sous-comptes dans la commande et que les champs sont remplis, on peut créer les sous-comptes
        if (!empty(clean_empty_array($subaccount_data))){
            if(isset($subaccount_data['email']) && !email_exists($subaccount_data['email'])) {
                // Créé un utilisateur pour le sous-compte
                $password = wp_generate_password(); // Génère un mot de passe pour le sous-compte
                $user_id = wp_create_user($subaccount_data['email'], $password, $subaccount_data['email']);

                if (!is_wp_error($user_id)) {
                    wp_update_user(array(
                        'ID'           => $user_id,
                        'first_name'   => $subaccount_data['first_name'],
                        'last_name'    => $subaccount_data['last_name'],
                    ));

                    // Ajoute la meta parent_user_id au sous-compte avec l'id du compte parent
                    update_user_meta($user_id, 'parent_user_id', $parent_user_id);

                    // Ajoute la date d'ajout en meta
                    update_user_meta($user_id, 'subaccount_added_date', current_time('mysql'));

                    // Ajoute les coordonnées d'expédition du sous-compte
                    $shipping_fields = array(
                        'first_name',
                        'last_name',
                        'company',
                        'address_1',
                        'address_2',
                        'city',
                        'postcode',
                        'country',
                        'state',
                        'phone',
                    );
                    
                    foreach ($shipping_fields as $field) {
                        if (isset($subaccount_data[$field])) {
                            if($field == 'country'){
                                $countries = WC()->countries->get_countries();
                                $value = $subaccount_data[$field];
                                $country_name = isset($countries[$value]) ? $countries[$value] : $value;

                                $subaccount_data[$field] = $country_name;
                            }
                            update_user_meta($user_id, 'shipping_' . $field, $subaccount_data[$field]);
                        }
                    }

                    // Récupère tous les plans
                    $plan_ids = wc_memberships_get_membership_plans();

                    foreach ($plan_ids as $plan) {
                        if (in_array($order_product_id, $plan->get_product_ids())) {
                            // Créé une adhésion pour ce sous-compte. Devient Membre de Membership
                            wc_memberships_create_user_membership(array(
                                'plan_id'  => $plan->get_id(),
                                'user_id'  => $user_id,
                                'product_id' => $order_product_id,
                                'status'   => 'active',
                            ));
                        }
                    }
                    
                    $new_user = new WP_User($user_id);
                    
                    // Assigner le rôle 'child_member_role'
                    $new_user->set_role('child_member_role');
                    
                    /* Si on a créé un sous-compte pour remplir un sous-compte disponible,
                    * on décrémente la meta empty_child_account du compte parent 
                    */
                    if(isset($subaccount_data['empty_child_account'])){
                        $user_empty_account--;
                    }
                    
                    send_email_to_new_user($subaccount_data, $password, $parent_user_id);
                }
            }
        }else{ // Sinon, on incrémente $user_empty_account pour le compte Parent

            // id de la variation du produit de l'item panier
            $variation_id = $item->get_variation_id();

            // Si elle correspond à l'id de la variation sous-compte, on incrémente $empty_count
            // $empty_count met à jour la meta empty_child_account du compte parent
            if(!empty($variation_id) && ($discounted_variation_id == $variation_id)){
                $user_empty_account++;
            }
        }


        // Ajoute le rôle Membre si l'utilisateur prend le produit lié au plan Carte Membre
        if(!empty($premium_product_id) && ($premium_product_id == $order_product_id)){
            // S'il est Client, on lui ajoute le role "member_role"
            if (in_array('customer', $user->roles) && !in_array('member_role', $user->roles)) {
                $user->add_role('member_role');
            }
        }
    }

    // Met à jour la meta empty_child_account du compte parent
    update_user_meta($parent_user_id, 'empty_child_account', $user_empty_account);

    // Affiche le nombre de sous-comptes disponibles
    display_empty_child_account_in_my_account();
    
    // Génère un xml de la commande pour SAYENS si le montant est différent de 0
    /* if($order->get_total() > 0){
        export_order_to_xml($order_id);
    } */
}

// Masque les taxes dans le total dans les détails de commande
add_filter('woocommerce_order_get_tax_totals', function($tax_totals, $order) {
    $billing_country = $order->get_billing_country();

    if($billing_country != 'FR'){
        return [];
    }else{
        return $tax_totals;
    }

}, 10, 2);

function send_email_to_new_user($subaccount_data, $password, $parent_user_id) {
    $parent_user = get_user_by('id', $parent_user_id);

    if($parent_user){
        $account_created_by = $parent_user->display_name;

        if(!empty(get_user_meta($parent_user_id, 'billing_company', true))){
            $account_created_by = get_user_meta($parent_user_id, 'billing_company', true);
        }
    }

    // Envoi d'un email à l'utilisateur
    $to = $subaccount_data['email'];
    $subject = 'Votre compte a été créé';

    // Charger l'instance du mailer WooCommerce
    $mailer = WC()->mailer();
    // Commencer le buffer pour capturer le contenu
    ob_start();
    

    $login_url = esc_url( wc_get_page_permalink( 'myaccount' ) );

    echo '<h2>Bonjour ' . $subaccount_data['first_name'] . ',</h2>';

    echo '<p>' . $account_created_by . ' vous a créé un compte sur notre site avec un accès Membre. </p>';
    echo '<p>Voici vos informations de connexion :</p>';
    echo '<p><strong>Email</strong> : ' . $subaccount_data['email'] . '</p>';
    echo '<p><strong>Mot de passe</strong> : ' . $password . '</p>';
    echo '<p>Vous pouvez vous connecter ici : <a href="' . $login_url . '" class="link">Je me connecte à mon compte</a></p>';

    
    // Récupérer le contenu du buffer
    $message = ob_get_clean();

    // Envoyer l'email via WooCommerce
    $mailer->send($to, $subject, $mailer->wrap_message($subject, $message));
}