<?php
/*
Template Name: Page Accueil boutique
*/
?>

<?php get_header(); ?>

<?php if (have_posts()) : while (have_posts()) : the_post();
    if (get_fields()) {
        extract(get_fields());
    } ?>
    <section id="page-content">
        <div class="grid-container">
            <div class="grid-x grid-padding-x">
                <div class="cell xlarge-7">
                    <h1><?php the_title(); ?></h1>
                </div>
            </div>

            <?php if(!empty(clean_empty_array($bloc))): ?>
                <div class="grid-x grid-padding-x align-justify">
                    <?php foreach($bloc as $item): 
                        if(!empty(clean_empty_array($item))): ?>
                            <div class="cell medium-6">
                                <?php $color = $item['background_color']; ?>
                                <?php if(!empty($item['link'])): ?>
                                    <a href="<?= $item['link']['url']; ?>" class="product-item <?php if(!empty($item['title']) || !empty($item['link']['title'])) echo 'has-content'; ?>" style="background-color: <?= $color; ?>;">
                                <?php else: ?>
                                    <div class="product-item <?php if(!empty($item['title']) || !empty($item['link']['title'])) echo 'has-content'; ?>" style="background-color: <?= $color; ?>;">
                                <?php endif; ?>
                                        <?php if(!empty($item['title']) || !empty($item['link']['title'])): ?>
                                            <div class="item-content">
                                                <?php if(!empty($item['title'])): ?>
                                                    <div class="title">
                                                        <?= strip_tags($item['title'], '<strong> </strong> <br>'); ?>
                                                    </div>
                                                <?php endif; ?>
                
                                                <?php if(!empty($item['link'])): ?>
                                                    <div class="link-title"><?= $item['link']['title']; ?></div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if(!empty($item['picture'])): ?>
                                            <div class="picture-wrapper">
                                                <?= wp_get_attachment_image($item['picture'], 'large'); ?>
                                            </div>
                                        <?php endif; ?>
                                <?php if(!empty($item['link'])): ?>
                                    </a>
                                <?php else: ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php endwhile;
endif; ?>

<?php get_footer(); ?>