<?php
get_header(); ?>

<section id="page-content">
	<div class="grid-container">
		<?php if ( have_posts() ) : ?>
            <div class="grid-x grid-padding-x align-center">
                <div class="cell xlarge-10">
					<div class="section-content" data-aos="fade-up">
						<h1><?= __('Résultats de recherche', 'ocim'); ?></h1>

						<div class="search-results">
							<?= $wp_query->found_posts; ?> 
							<?php if($wp_query->found_posts > 1){ 
								echo 'résultats'; 
							}else{ 
								echo 'résultat'; 
							}; ?> pour : " <strong><?php if(the_search_query() != null){ 
								echo get_search_query();
							} ?></strong>
						</div>
					</div>
                </div>
            </div>

			<div class="grid-x grid-padding-x align-center">
				<?php while (have_posts()) : the_post(); ?>    
					<div class="cell medium-6 large-4 xlarge-3">
						<?php $post_type = get_post_type();
						if($post_type == 'product'){
							$link = get_the_permalink();
						}else{
							$post_path = str_replace( home_url(), "", get_the_permalink() );
							$link = SITEFRONT . $post_path;
						} ?>
						<a href="<?= esc_url($link); ?>" class="product-item">
							<div class="picture-wrapper">
								<?php if(!empty(get_post_thumbnail_id( $product_id ))){
									echo wp_get_attachment_image(get_post_thumbnail_id( $product_id ), 'large');
								}else{
									echo '<img src="'. wc_placeholder_img_src('large') . '" alt="'. get_the_title(). '" loading="lazy">';  // Change the URL to your placeholder image.
								} ?>
							</div>

							<div class="item-content">
								<?php
								$tags = array();
								if($post_type == 'product'){
									$tags[] = [
										'class' => 'product',
										'title' => 'Produit'
									]; 
								}
								if(is_a_restricted_content(get_the_ID())){
									$tags[] = [
										'class' => 'restricted',
										'title' => 'Contenu'
									];
								} 
								
								if(!empty($tags)): 
									foreach($tags as $tag): ?>
										<div class="tag <?= $tag['class']; ?>"><?= $tag['title']; ?></div>
									<?php endforeach; ?>
								<?php endif; ?>

								<h3 class="title">
									<?php the_title(); ?>
								</h3>

								<?php if (!empty(get_main_term('product_cat')) && get_main_term('product_cat')['slug'] != 'non-classe') : ?>
									<span class="category"><?= get_main_term('product_cat')['name']; ?></span>
								<?php endif; ?>

								<div class="excerpt">
									<p><?= excerpt(30); ?></p>
								</div>

								<div class="button-wrapper">
									<div class="button">
										<?= __('En savoir plus', 'ocim'); ?>
										<div class="bouton-cyan"></div>
									</div>
								</div>
							</div>
						</a>
					</div>
				<?php endwhile; ?>
			</div>
		<?php else : ?>
			<div class="grid-x grid-padding-x align-center">
                <div class="cell xlarge-10">
					<div class="section-content" data-aos="fade-up">
						<h1>
							<?php
								/* translators: %s: search term */
								printf( esc_attr__( 'Aucun résultat pour : %s', 'ocim' ), '<span>' . get_search_query() . '</span>' );
							?>
						</h1>
					</div>
                </div>
            </div>
		<?php endif; ?>
	</div>
</section>

<?php get_footer();