import { Foundation } from 'foundation-sites/js/foundation.core';
Foundation.addToJquery($);
import { MediaQuery } from 'foundation-sites/js/foundation.util.mediaQuery';
Foundation.plugin(MediaQuery, 'MediaQuery');
import { DropdownMenu } from 'foundation-sites/js/foundation.dropdownMenu';
Foundation.plugin(DropdownMenu, 'DropdownMenu');
import { AccordionMenu } from 'foundation-sites/js/foundation.accordionMenu';
Foundation.plugin(AccordionMenu, 'AccordionMenu');
import GLightbox from 'glightbox';

// Components
import { searchForm } from './components/_searchForm';
import HeaderClass from './components/_header';
import { addCouponMessage } from './components/_addCouponMessage';

// Pages
import { cartPage } from './pages/cart';
import { myAccountPage } from './pages/myAccount';
import { checkoutPage } from './pages/checkout';


// ----------------------------------- DOCUMENT READY -----------------------------------
// --------------------------------------------------------------------------------------
jQuery(function () {
    Foundation.MediaQuery._init();
    
    // Init Header class
    let header = new HeaderClass();
    header.initHeader();

    
    // Ouvre/ferme le champs de recherche dans le header
    searchForm.init();

    const lightbox = GLightbox();

    // Popup d'événement
    if($('#event-popup').length){
        if (sessionStorage.getItem('event-popup') !== "true") {
            lightbox.open('#event-popup');

            sessionStorage.setItem('event-popup', "true");
        }
    }

    addCouponMessage.init();
    
    let bodyClassList = document.getElementsByTagName('body')[0].classList;
    switch (true) {
        case bodyClassList.contains('woocommerce-cart'):
            cartPage.readyFn();
            break;
        case bodyClassList.contains('woocommerce-account'):
            myAccountPage.readyFn();
            break;
        case bodyClassList.contains('woocommerce-checkout'):
            checkoutPage.readyFn();
            break;
    }
});