const cartPage = {
    readyFn: function () {

        let deleteProductUrl = '';

        $('.woocommerce-cart').on('click', '.product-remove .remove', function (e) {            
            e.preventDefault();
            e.stopPropagation();

            // Stocke l'URL d'action de suppression
            deleteProductUrl = $(this).data('product');
        });
        
        // Dans la popup de confirmation, au clic sur le bouton on lance la suppression du produit
        $('.woocommerce-cart').on('click', '.popup .confirm-delete', function (e) {            
            window.location.href = deleteProductUrl;
        });

        $('.woocommerce-cart').on('click', '.toggle-fields', function (e) {
            e.preventDefault();
            $(this).next('.fields-wrapper').slideToggle('fast');
        });

        // Toggle visibility of quantity field wrapper
        $('.woocommerce-cart').on('click', '.toggle-quantity-field', function (e) {
            e.preventDefault();
            $(this).next('.quantity-field-wrapper').slideToggle('fast');
        });


        // Ajouter la quantité de sous-comptes au panier
        $('.woocommerce-cart').on('click', '.add-subaccount-button', function(e) {
            e.preventDefault();

            let button = $(this);
            let variation_id = button.data('variation-id');
            $('#subaccount_quantity_' + button.data('cart-key')).trigger('change');
            let quantity = parseInt($('#subaccount_quantity_' + button.data('cart-key')).val());

            // Vérification de la quantité
            if (isNaN(quantity) || quantity < 1) {
                alert('Veuillez entrer une quantité valide.');
                return;
            }

            // Désactiver le bouton pendant la requête
            button.prop('disabled', true).text('Ajout en cours...');

            // Requête AJAX
            $.ajax({
                type: 'POST',
                url: adminAjax.url,
                data: {
                    action: 'add_subaccount_variation_to_cart',
                    variation_id: variation_id,
                    quantity: quantity
                },
                success: function (response) {
                    console.log('response', response);
                    
                    if (response.success) {
                        const updateCartButton = $('button[name="update_cart"]');
                        if (updateCartButton.length) {                            
                            updateCartButton.trigger('click');
                        }
                    } else {
                        alert(response.data || 'Erreur lors de l\'ajout des sous-comptes.');
                    }
                },
                error: function() {
                    alert('Une erreur est survenue.');
                },
                complete: function() {
                    button.prop('disabled', false).text('Ajouter des sous-comptes');
                }
            });
        });


        // Au clic sur le bouton pour valider le panier, on ajouter les données du formulaire de cart dans les meta du panier
        $('.wc-proceed-to-checkout .checkout-button').on('click', function (e) {
            e.preventDefault();
            let thisLinkUrl = $(this).attr('href');

            if ($('.registration-form').length) {
                let form = $('form.woocommerce-cart-form')[0];

                for (var i = 0; i < form.elements.length; i++) {
                    if (form.elements[i].value === '' && form.elements[i].hasAttribute('required')) {
                        alert('Veuillez remplir tous les champs obligatoires.');
                        return;
                    }
                }
            }

            $.ajax({
                url: adminAjax.url,
                type: 'POST',
                data: {
                    action: 'add_cart_meta',
                    cart_data: $('form.woocommerce-cart-form').serialize(), // Récupère les données du formulaire
                    security: adminAjax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        window.location.href = thisLinkUrl;
                    }
                }
            });
        });
    }
}

export { cartPage };