import GLightbox from 'glightbox';

const checkoutPage = {
    readyFn: function () {
        let self = this;

        if ($('form.checkout').length) {
            const lightbox = GLightbox();


            $('#billing_company_field .optional, #billing_siret_field .optional, #billing_taxe_intra_field .optional, #billing_type_activite_field .optional').remove();
            $('#billing_company_field abbr').remove();
            $('#billing_company, #billing_siret, #billing_taxe_intra, #billing_type_activite').removeAttr('aria-required');
            
            // Afficher/masquer les champs SIREN et SIRET en fonction de la case à cocher Entreprise
            if (document.getElementById('billing_is_company') != null) {
                self.setRequiredCompanyFields(document.getElementById('billing_is_company'));
                $('#page-content').on('change', '#billing_is_company', function () {
                    self.setRequiredCompanyFields(this);
                });
            }

            $('body').on('click', '#generate-quote-btn', function (e) {
                // Valide les champs requis
                if (!self.validateCheckoutFields()) {
                    return; // Arrête si la validation échoue
                }

                $.ajax({
                    url: adminAjax.url,
                    type: 'POST',
                    data: {
                        action: 'generate_quote_pdf',
                        checkout_data: $('form.checkout').serialize(), // Récupère les données du formulaire
                        security: woocommerce_params.ajax_nonce
                    },
                    beforeSend: function () {
                        $('#generate-quote-btn').text('Generation en cours...').prop('disabled', true);
                    },
                    success: function (response) {
                        if (response.success) {
                            $('#generate-quote-btn').text('Devis envoyé');
                            alert(response.data.message || 'Votre devis est bien envoyé');
                        } else {
                            $('#generate-quote-btn').text('Le devis n\'a pas pu être envoyé');
                            alert(response.data.message || 'An error occurred.');
                        }
                    },
                    error: function () {
                        alert('Une erreur est survenue lors de la génération du devis.');
                    },
                });
            });


            $('form.checkout').on( 'change', '.woocommerce-billing-fields input[type=file]', function(e) {
                const files = $(this).prop('files');

                if ( files.length ) {
                    const maxSize = $(this).data('max_size');
                    var message = '';
                    var fileInput = $(this)[0];
                    var justifFile = fileInput.files[0];
                    var acceptAttr = $(fileInput).attr('accept') || '';
                    var allowedExtensions = acceptAttr
                        .split(',')
                        .map(function (ext) {
                            return ext.trim().replace('.', '').toLowerCase();
                        });
                    var maxFileSize = 5 * 1024 * 1024; // 5 Mo en octets
                    var fileName = justifFile.name.toLowerCase();                        

                    // Vérifier l'extension
                    var fileExtension = fileName.split('.').pop();
                    if (allowedExtensions.length > 0 && !allowedExtensions.includes(fileExtension)) {
                        message = 'Seuls les fichiers avec les extensions suivantes sont autorisés : ' + allowedExtensions.join(', ');
                        $( '.upload-response' ).html( message ).css('color','red').fadeIn('fast');
                        e.preventDefault(); // Empêche la soumission du formulaire
                        return false;
                    }

                    // Vérifier la taille du fichier
                    if ( maxSize > 0 && justifFile.size > ( maxSize * 1024 ) ) {
                        message = 'La taille maximale du fichier est de 5 Mo.';
                        $( '.upload-response' ).html( message ).css('color','red').fadeIn('fast');
                        e.preventDefault(); // Empêche la soumission du formulaire
                        return false;
                    }

                    if(message == ''){
                        $('.upload-response').html('').fadeOut('fast');
                    }

                    const formData = new FormData();
                    formData.append( 'action', 'checkout_upload' );
                    formData.append( 'nonce', adminAjax.nonce );
                    formData.append( 'file', justifFile );

                    $.ajax({
                        url: adminAjax.url,
                        type: 'POST',
                        data: formData,
                        contentType: false,
                        enctype: 'multipart/form-data',
                        processData: false,
                        success: function ( response ) {
                            $('form.checkout').unblock();
                            $( '.upload-response' ).html( response ).fadeIn().delay(2000).fadeOut();
                        },
                        error: function ( error ) {
                            $('form.checkout').unblock();
                            $( '.upload-response' ).html( error ).css('color','red').fadeIn().delay(2000).fadeOut();
                        }
                    });
                }
            });


            $('#billing_company, #billing_country').on('change', function () {
                // Déclencher la mise à jour du récapitulatif
                $('body').trigger('update_checkout');
            });
            
            
            $('body').on('updated_checkout', function () {
                updateBodyClass();

                $('#payment_method_offline_gateway').on('input', function () {
                    if ($('#payment_method_offline_gateway').is(':checked')) {
                        lightbox.open('#bdc-message');
                    }
                });
            });


            // Si un coupon de réduction est appliqué, on ajoute la class coupon-applied sur le body. Ca masque le bouton de demande de devis
            function updateBodyClass() {
                $.get(adminAjax.url, { action: 'get_applied_coupons' }, function (response) {
                    $('body').removeClass(function (index, className) {
                        return (className.match(/(\bcoupon-[^\s]+)/g) || []).join(' ');
                    });
        
                    if (response && response.length > 0) {
                        $('body').addClass('coupon-applied');
                    } else {
                        $('body').removeClass('coupon-applied');
                    }
                });
            }
        }
    },

    validateCheckoutFields: function() {
        let isValid = true;
        let errorMessage = '';
        
        let $inputs = [$('.woocommerce-billing-fields .validate-required input')];

        if ($('#ship-to-different-address-checkbox').is(':checked')) {
            $inputs.push($('.woocommerce-shipping-fields.validate-required input'));
        }

        // Parcourt tous les champs requis
        $inputs.forEach(element => {
            element.each(function () {
                const $field = $(this);               
    
                // Vérifie si le champ est vide
                if ($field.val().trim() === '') {
                    isValid = false;
                    errorMessage = 'Certains champs requis ne sont pas remplis correctement.';
                    $field.parents('.validate-required').addClass('woocommerce-invalid'); // Ajoute une classe d'erreur
                } else {
                    $field.parents('.validate-required').removeClass('woocommerce-invalid'); // Supprime la classe d'erreur
                }
            });
        });

        if (!isValid) {
            // Affiche un message dans la notice WooCommerce
            if (!$('.woocommerce-error').length) {
                $('form.checkout').prepend(`<ul class="woocommerce-error"><li>${errorMessage}</li></ul>`);
            }
            
            let headerHeight = document.getElementsByTagName('header')[0].offsetHeight;

            $('html, body').animate({
                scrollTop: ($('.woocommerce-error').offset().top - headerHeight) + 'px'
            }, 400);
        } else {
            $('.woocommerce-error').remove(); // Supprime les anciens messages d'erreur
        }

        return isValid;
    },

    setRequiredCompanyFields: function (checkbox) {
        const ids = ['billing_company_field', 'billing_siret_field', 'billing_taxe_intra_field', 'billing_type_activite_field'];
        const $selector = ids.map(id => `#${id}`).join(', ');
        
        // Si la checkbox est cochée
        if (checkbox.checked) {
            $('#billing_company_field').removeClass('hidden');
            $('#billing_company').attr('aria-required', true);
            
            $($selector).each(function () {
                let $thisSelector = $(this);
                $thisSelector.addClass('validate-required');
                $thisSelector.find('label').append('<abbr class="required" title="obligatoire">*</abbr>');
            });
        } else {
            $('#billing_company_field').addClass('hidden');
            $('#billing_company').removeAttr('aria-required');

            // Pour chaque champs entreprise on enlève le required et supp les values
            $($selector).each(function () {
                let $thisSelector = $(this);
                $thisSelector.removeClass('validate-required');
                $thisSelector.find('abbr').remove();
                //$thisSelector.find('input').val('').attr('value', '');
            });
        }
        
        // Affiche/masque les wrappers de champs
        $($selector).each(function () {
            $(this).toggle(checkbox.checked);
        });
        
        // Active/désactive les champs en required
        $('#billing_company, #billing_siret, #billing_taxe_intra, #billing_type_activite').prop('required', checkbox.checked);
    }
}

export { checkoutPage };