const CopyWebpackPlugin = require('copy-webpack-plugin');
const path = require('path');

module.exports = {
    output: {
        filename: 'js/[name].js',
        path: path.resolve(__dirname, 'dist'),
    },
    module: {
        rules: [
            {
                test: /\.js$/,
                exclude: /node_modules/,
                loader: "babel-loader"
            },
            {
                test: /\.(otf|eot|ttf|woff|woff2)$/,
                type: 'asset/resource',
                /* use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: './fonts/[name].[contenthash].[ext]',
                            context: path.resolve(__dirname, "src/"),
                            outputPath: '/',
                            publicPath: '../',
                            useRelativePaths: true
                        }
                    }
                ] */
            },
            {
                test: /\.(jpe?g|png|gif|svg)(\?[a-z0-9=.]+)?$/,
                type: 'asset/resource',
                /* generator: {
                    filename : 'images/[name][ext]'
                } */
            }
        ]
    },
    plugins: [
        new CopyWebpackPlugin({
            patterns: [
                { from: 'src/images', to: './images/' }
            ]
        })
    ],
};