const webpack = require('webpack');
const commonConfig = require('./webpack.common.js');
const productionConfig = require('./webpack.prod.js');
const watchConfig = require('./webpack.watch.js');

module.exports = function(env) {
    switch (env) {
        case 'production':
            return merge(commonConfig, productionConfig);
        case 'development':
            return merge(commonConfig, watchConfig);
        default:
            throw new Error('No matching configuration found');
    }
}