const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const CssMinimizerPlugin = require("css-minimizer-webpack-plugin");
const TerserPlugin = require('terser-webpack-plugin');
const autoprefixer = require('autoprefixer');
const {merge} = require('webpack-merge');
const common = require('./webpack.common.js');

module.exports = merge(common, {
    mode: 'production',
    entry: {
        "main": './src/js/main.js',
        "admin": './src/js/admin.js',
        "style": './src/scss/style.scss',
        "style-editor": './src/scss/style-editor.scss',
    },
    module: {
        rules: [
            {
                test: /\.s?css$/,
                use: [
                    MiniCssExtractPlugin.loader,
                    {
                        loader: 'css-loader',
                        options: {
                            sourceMap: false,
                        },
                    },
                    {
                        loader: 'postcss-loader',
                        options: {
                            postcssOptions: {
                                map: false,
                                plugins: [autoprefixer]
                            }
                        }
                    },
                    {
                        loader: 'sass-loader',
                    },
                ]
            },
        ]
    },
    optimization: {
        minimize : true,
        minimizer: [
            new TerserPlugin({
                terserOptions: {
                    compress: {
                        drop_console: true, // Supprime les console (console.log, etc)
                    }
                }
            }), 
            new CssMinimizerPlugin()
        ],
    },
    plugins: [
        new MiniCssExtractPlugin({
            //filename: ({ chunk }) => `${chunk.name.replace("/css/")}.css`,
            filename: "css/[name].css"
        }),
    ],
    output: {
        //path: path.resolve(__dirname, 'dist'),
        clean: true,
    },
});