<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

get_header( 'shop' ); ?>

<section id="products">
	<div class="grid-container">
		<div class="grid-x grid-padding-x">
			<div class="cell xlarge-7">
				<?php do_action( 'woocommerce_shop_loop_header' ); ?></h1>
			</div>
		</div>

		<div class="grid-x grid-padding-x">
			<div class="cell">
				<?php
				/**
				* Hook: woocommerce_before_shop_loop.
				*
				* @hooked woocommerce_output_all_notices - 10
				* @hooked woocommerce_result_count - 20
				* @hooked woocommerce_catalog_ordering - 30
				*/
				echo '<div id="products-filters">';
				do_action( 'woocommerce_before_shop_loop' );
				echo '</div>';

				woocommerce_product_loop_start();

				if ( wc_get_loop_prop( 'total' ) ) {
					while ( have_posts() ) {
						the_post();

						/**
						 * Hook: woocommerce_shop_loop.
						 */
						do_action( 'woocommerce_shop_loop' );

						wc_get_template_part( 'content', 'product' );
					}
				}

				woocommerce_product_loop_end(); ?>
			</div>
		</div>

		<!-- Pagination -->
        <div class="grid-x grid-padding-x">
            <div class="cell">
                <?php woocommerce_pagination(); ?>
            </div>
        </div>
	</div>
</section>

<?php get_footer( 'shop' );