<?php
/**
 * Output a single payment method
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment-method.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<li class="wc_payment_method payment_method_<?php echo esc_attr( $gateway->id ); ?>">
	<input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> data-order_button_text="<?php echo esc_attr( $gateway->order_button_text ); ?>" />
	<label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>">
		<?php echo $gateway->get_title(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?> <?php echo $gateway->get_icon(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>
	</label>
	<?php if($gateway->id == 'offline_gateway'){
		if(get_field('text_bdc', 'option')){
			$text = get_field('text_bdc', 'option');
		}else{
			$text = "<p>
			<strong> ATTENTION </strong>: les bons de commandes sont à adresser à SATT SAYENS, gestionnaire pour l'OCIM, dont les coordonnées sont les suivantes :<br><br>
			<strong>SATT SAYENS<br>
			64 Rue de Sully<br>
			21000 DIJON CEDEX<br>
			FRANCE<br>
			Tél. : 03 80 40 34 80</strong><br><br>
			Coordonnées bancaires de SATT SAYENS : <br><br>
			IBAN : FR 76 1213 5003 0008 0022 2597 251<br>
			BIC : CEPAFRPP213<br>
			Siret : 501 704 969 00051<br>
			N° de TVA Intrac. : FR63501704969</p>";
		}
		echo '<div class="woocommerce-notices-wrapper"><div class="message-bdc woocommerce-message" role="alert">' . $text . '</div></div>'; ?>

		<?php if(get_field('popup_message_bdc', 'option')): ?>
			<a href="#bdc-message" class="glightbox" style="display: none; position: absolute; left: -1000px; top: -1000px;"></a>
			<div id="bdc-message" style="display: none;">
				<div class="wysiwyg"><?php the_field('popup_message_bdc', 'option'); ?></div>
			</div>
		<?php endif; ?>
	<?php }; ?>
	
	<?php if ( $gateway->has_fields() || $gateway->get_description() ) : ?>
		<div class="payment_box payment_method_<?php echo esc_attr( $gateway->id ); ?>" <?php if ( ! $gateway->chosen ) : /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>style="display:none;"<?php endif; /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>>
			<?php $gateway->payment_fields(); ?>
		</div>
	<?php endif; ?>
</li>
