<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="grid-x grid-padding-x align-center">
	<div class="cell large-10 xlarge-8">
		<div class="woocommerce-order">
			<?php
			if ( $order ) :
				do_action( 'woocommerce_before_thankyou', $order->get_id() );
				?>
		
				<?php if ( $order->has_status( 'failed' ) ) : ?>
		
					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>
		
					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
						<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
						<?php if ( is_user_logged_in() ) : ?>
							<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
						<?php endif; ?>
					</p>
		
				<?php else : ?>
		
					<?php wc_get_template( 'checkout/order-received.php', array( 'order' => $order ) ); ?>
		
					<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
		
						<li class="woocommerce-order-overview__order order">
							<?php esc_html_e( 'Order number:', 'woocommerce' ); ?>
							<strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
						</li>
		
						<li class="woocommerce-order-overview__date date">
							<?php esc_html_e( 'Date:', 'woocommerce' ); ?>
							<strong><?php echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
						</li>
		
						<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
							<li class="woocommerce-order-overview__email email">
								<?php esc_html_e( 'Email:', 'woocommerce' ); ?>
								<strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
							</li>
						<?php endif; ?>
		
						<li class="woocommerce-order-overview__total total">
							<?php esc_html_e( 'Total:', 'woocommerce' ); ?>
							<strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
						</li>
		
						<?php if ( $order->get_payment_method_title() ) : ?>
							<li class="woocommerce-order-overview__payment-method method">
								<?php esc_html_e( 'Payment method:', 'woocommerce' ); ?>
								<strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>

								<?php 
									// Récupérer l'ID de la commande
									$order_id = $order->get_id();

									// Récupérer la valeur de la métadonnée 'ocim_bdc'
									$ocim_bdc = get_post_meta( $order_id, 'ocim_bdc', true );


									// Si la métadonnée existe, afficher le lien
									if ( ! empty( $ocim_bdc ) ) {
										$bon_url = unserialize(urldecode($ocim_bdc))["url"];

										if(!empty($bon_url)){
											echo '<p class="custom-payment-info">';
											echo sprintf(
												__( '<a href="%s" target="_blank" class="button primary medium">Bon de commande</a>', 'ocim' ),
												esc_url( $bon_url )
											);
											echo '</p>';
										}
									}
								?>
							</li>
						<?php endif; ?>
		
						<?php
						// Récupérer l'URL du fichier depuis les métadonnées de la commande
						$uploaded_justif_url = get_post_meta( $order_id, 'ocim_justif', true );

						if ( !empty($uploaded_justif_url )) {
							$justif_url = unserialize(urldecode($uploaded_justif_url))["url"];

							echo '<li>';
							echo __( 'Votre justificatif :', 'ocim' );
							echo '<p class="custom-payment-info"><a href="' . esc_url( $justif_url ) . '" target="_blank" class="button primary medium">' . __( 'Télécharger le fichier', 'ocim' ) . '</a></p>';
							echo'</li>';
						} ?>
					</ul>
				<?php endif; ?>
		
				<?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>
				<?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>
			<?php else : ?>
		
				<?php wc_get_template( 'checkout/order-received.php', array( 'order' => false ) ); ?>
		
			<?php endif; ?>
		
			<div class="button-wrapper align-center">
				<a class="button wc-backward<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
					<?php
						/**
						 * Filter "Return To Shop" text.
						 *
						 * @since 4.6.0
						 * @param string $default_text Default text.
						 */
						echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Return to shop', 'woocommerce' ) ) );
					?>
				</a>
			</div>
		</div>
	</div>
</div>
