<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$product_id = $product->get_id();
?>
<li <?php wc_product_class( '', $product ); ?>>
	<a href="<?php the_permalink(); ?>" class="product-item">
		<div class="picture-wrapper">
			<?php if(!empty(get_post_thumbnail_id( $product_id ))){
				echo wp_get_attachment_image(get_post_thumbnail_id( $product_id ), 'large');
			 }else{
				echo '<img src="'. wc_placeholder_img_src('large') . '" alt="'. get_the_title(). '" loading="lazy">';  // Change the URL to your placeholder image.
			 } ?>
		</div>

		<div class="item-content">
			<h3 class="title">
				<?php the_title(); ?>
			</h3>

			<?php if (!empty(get_main_term('product_cat')) && get_main_term('product_cat')['slug'] != 'non-classe') : ?>
				<strong class="category"><?= get_main_term('product_cat')['name']; ?></strong>
			<?php endif; ?>

			<?php if(!empty(get_field('issue'))){
				echo '<div class="issue">Numéro : '. get_field('issue'). '</div>';
			} ?>

			<div class="excerpt">
				<p><?= excerpt(20); ?></p>
			</div>

			<p class="<?= esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>">
				<?php if ( $product->is_type( 'variable' ) ) : ?>
					<?php
					// Pour les produits variables, récupérer le prix minimum et maximum TTC
					$min_price = wc_price( $product->get_price_including_tax( 1, $product->get_variation_price( 'min' ) ) );
					$max_price = wc_price( $product->get_price_including_tax( 1, $product->get_variation_price( 'max' ) ) );

					if ( $min_price === $max_price ) {
						// Si le prix minimum et maximum sont identiques, afficher un seul prix
						echo '<strong>' . $min_price . '</strong>';
					} else {
						// Sinon, afficher une plage de prix
						echo '<strong>' . sprintf( __( 'De %s à %s', 'ocim' ), $min_price, $max_price ) . '</strong>';
					}
					?>
				<?php else : ?>
					<?php
					// Pour les produits simples, afficher le prix TTC
					$price_including_tax = wc_price( $product->get_price_including_tax() );
					echo '<strong>' . $price_including_tax . '</strong>';
					?>
				<?php endif; ?>
			</p>

			<div class="button-wrapper">
				<div class="button">
					<?= __('En savoir plus', 'ocim'); ?>
					<div class="bouton-cyan"></div>
				</div>
			</div>
		</div>
	</a>
</li>
