<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

if(get_fields()){
	extract(get_fields());
}

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<section id="product-content">
		<div class="grid-container">
			<div class="grid-x grid-padding-x grid-padding-y align-justify">
				<div class="cell large-7">
					<div class="d-flex align-middle mb-2">

						<?php
							$main_category = get_main_term('product_cat');
							
							if(!empty($main_category)){
								echo '<a class="button back-to-shop primary medium" href="' . get_term_link($main_category['slug'], 'product_cat')  . '" >' . $main_category['name']  . '</a>';
							}
						?>
						<a class="category-link" href="/boutique">Retour à la boutique</a>
					</div>

					<?php
					/**
					 * Hook: woocommerce_single_product_summary.
					 *
					 * @hooked woocommerce_template_single_title - 5
					 * @hooked woocommerce_template_single_rating - 10
					 * @hooked woocommerce_template_single_price - 10
					 * @hooked woocommerce_template_single_excerpt - 20
					 * @hooked woocommerce_template_single_add_to_cart - 30
					 * @hooked woocommerce_template_single_meta - 40
					 * @hooked woocommerce_template_single_sharing - 50
					 * @hooked WC_Structured_Data::generate_product_data() - 60
					 */
					do_action( 'woocommerce_single_product_summary' ); ?>

					<div class="product-infos">
						<?php
						if(!empty($issue)){
							echo '<div class="info-item issue"><span class="info-name">Numéro de publication</span> <span class="info">' . $issue . '</span></div>';
						}
						if(!empty($year)){
							echo '<div class="info-item year"><span class="info-name">Période</span> <span class="info">' . $year . '</span></div>';
						}
						if(!empty($pages)){
							echo '<div class="info-item pages"><span class="info-name">Nombre de pages</span> <span class="info">' . $pages . '</span></div>';
						}
						if(!empty($issn)){
							echo '<div class="info-item issn"><span class="info-name">ISSN</span> <span class="info">' . $issn . '</span></div>';
						}
						if(!empty($author)){
							echo '<div class="info-item author"><span class="info-name">Auteur(s)</span> <span class="info">' . $author . '</span></div>';
						}
						if(!empty($subtitle)){
							echo '<div class="info-item subtitle"><span class="info-name">Sous-titre</span> <span class="info">' . $subtitle . '</span></div>';
						}
						if(!empty($rubric)){
							echo '<div class="info-item rubric"><span class="info-name">Rubrique</span> <span class="info">' . $rubric . '</span></div>';
						}
						if(!empty($format)){
							echo '<div class="info-item format"><span class="info-name">Format</span> <span class="info">' . $format . '</span></div>';
						}						
						if(!empty($collection)){
							echo '<div class="info-item collection"><span class="info-name">Collection</span> <span class="info">' . $collection . '</span></div>';
						}						
						if(!empty($reading_time)){
							echo '<div class="info-item reading-time"><span class="info-name">Temps de lecture</span> <span class="info">' . $reading_time . '</span></div>';
						}
						if(!empty($date)){
							echo '<div class="info-item date"><span class="info-name">Date d\'évènement</span> <span class="info">' . $date . '</span></div>';
						}
						if(!empty($editor)){
							echo '<div class="info-item editor"><span class="info-name">Editeur</span> <span class="info">' . $editor . '</span></div>';
						}
						if(!empty($place)){
							echo '<div class="info-item place"><span class="info-name">Lieu de l\'évènement</span> <span class="info">' . $place . '</span></div>';
						}
						if(!empty($agenda)){
							echo '<div class="info-item agenda"><span class="info-name">Programme de l\'évènement</span> <span class="info">' . $agenda . '</span></div>';
						}
						if(!empty($event_details)){
							echo '<div class="info-item event_details"><span class="info-name">Détails de l\'évènement</span> <span class="info">' . $event_details . '</span></div>';
						}
						?>
					</div>
				</div>

				<div class="cell large-6 xlarge-4">
					<?php
					/**
					 * Hook: woocommerce_before_single_product_summary.
					 *
					 * @hooked woocommerce_show_product_sale_flash - 10
					 * @hooked woocommerce_show_product_images - 20
					 */
					do_action( 'woocommerce_before_single_product_summary' );
					?>
				</div>
			</div>
		</div>
	</section>

	<section id="product-detail">
		<div class="grid-container">
			<div class="grid-x grid-padding-x align-center">
				<div class="cell xlarge-10">
					<?= woocommerce_output_product_data_tabs(); ?>
				</div>
			</div>
		</div>
	</section>

	<?php
	// Récupérer les produits en upsell
	$upsell_ids = wc_get_product(get_the_ID())->get_upsell_ids();

	if ( ! empty( $upsell_ids ) ) : ?>
		<section id="upsell-products">
			<div class="grid-container">
				<div class="grid-x grid-padding-x grid-padding-y align-center">
					<div class="cell">
						<?= woocommerce_upsell_display(); ?>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

	<?php
	// Récupérer les produits liés
	$related_ids = wc_get_related_products( get_the_ID(), wc_get_loop_prop( 'columns' ) );

	if ( ! empty( $related_ids ) ): ?>
		<section id="related-products">
			<div class="grid-container">
				<div class="grid-x grid-padding-x grid-padding-y align-center">
					<div class="cell">
						<?= woocommerce_output_related_products(); ?>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
