<?php
/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.7.0
 */

defined( 'ABSPATH' ) || exit;

$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();
?>
<section class="woocommerce-customer-details">

	<?php if ( $show_shipping ) : ?>

	<section class="grid-x grid-padding-x woocommerce-columns--addresses addresses">
		<div class="cell large-6 woocommerce-column--billing-address">

	<?php endif; ?>

	<h2 class="woocommerce-column__title"><?php esc_html_e( 'Billing address', 'woocommerce' ); ?></h2>

	<address>
		<?= wp_kses_post( $order->get_formatted_billing_address( esc_html__( 'N/A', 'woocommerce' ) ) ); ?>

		<?php if ( $order->get_billing_phone() ) : ?>
			<div class="woocommerce-customer-details--phone"><?= esc_html( $order->get_billing_phone() ); ?></div>
		<?php endif; ?>

		<?php if ( $order->get_billing_email() ) : ?>
			<div class="woocommerce-customer-details--email"><?= esc_html( $order->get_billing_email() ); ?></div>
		<?php endif; ?>

		<?php
		// Afficher les champs personnalisés
		if ( $order->get_meta('_billing_siret') ) {
			echo __( 'SIRET : ', 'ocim' ) . esc_html( $order->get_meta('_billing_siret') ) . '<br>';
		}

		if ( $order->get_meta('_billing_taxe_intra') ) {
			echo __( 'TVA intracommunautaire : ', 'ocim' ) . esc_html( $order->get_meta('_billing_taxe_intra') ) . '<br>';
		}

		if ( $order->get_meta('_billing_type_activite') ) {
			echo __( 'Nature de l\'activité : ', 'ocim' ) . esc_html( $order->get_meta('_billing_type_activite') );
		}

		/**
		 * Action hook fired after an address in the order customer details.
		 *
		 * @since 8.7.0
		 * @param string $address_type Type of address (billing or shipping).
		 * @param WC_Order $order Order object.
		 */
		do_action( 'woocommerce_order_details_after_customer_address', 'billing', $order );
		?>
	</address>

	<?php if ( $show_shipping ) : ?>

		</div><!-- /.col-1 -->

		<div class="cell large-6 woocommerce-column--shipping-address">
			<h2 class="woocommerce-column__title"><?php esc_html_e( 'Shipping address', 'woocommerce' ); ?></h2>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'woocommerce' ) ) ); ?>

				<?php if ( $order->get_shipping_phone() ) : ?>
					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
				<?php endif; ?>

				<?php
					/**
					 * Action hook fired after an address in the order customer details.
					 *
					 * @since 8.7.0
					 * @param string $address_type Type of address (billing or shipping).
					 * @param WC_Order $order Order object.
					 */
					do_action( 'woocommerce_order_details_after_customer_address', 'shipping', $order );
				?>
			</address>
		</div><!-- /.col-2 -->

	</section><!-- /.col2-set -->

	<?php endif; ?>

	<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>

</section>
